/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKBTAB_H
#define _IKBTAB_H

#include <iakb.h>
#include <iickb.h>
#include <iivkb.h>
#include <iikbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsTable;

template <class Element, class Key, class ElementOps>
class IGKeyBagAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeyBagAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsTableCursor
                            (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeyBagAsTable :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsTable <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeyBagAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeyBagAsTable
                            (INumber = 100);

           IGKeyBagAsTable
                            (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsTable <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeyBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeyBagAsTable :
  public IGKeyBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeyBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeyBagAsTable <Element, Key> Self;

#define IKeyBagAsTableTypedef(Element, Key)\
  typedef  IKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeyBagAsTable
                            (INumber = 100);


protected:

           IKeyBagAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeyBagAsTable :
  public IGKeyBagAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsTableTypedef (Element, Key, ElementOps);

public:

           IVGKeyBagAsTable
                            (INumber = 100);


protected:

           IVGKeyBagAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeyBagAsTable :
  public IVGKeyBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeyBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeyBagAsTable <Element, Key> Self;

#define IVKeyBagAsTableTypedef(Element, Key)\
  typedef  IVKeyBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeyBagAsTable
                            (INumber = 100);


protected:

           IVKeyBagAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikbtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
