/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeyBagAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsTableCursor <Element, Key, ElementOps>::
IGKeyBagAsTableCursor
  (IGKeyBagAsTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsTableCursor <Element, Key, ElementOps>&
IGKeyBagAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeyBagAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsTableCursor <Element, Key, ElementOps>::
IGKeyBagAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeyBagAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsTable <Element, Key, ElementOps>::
IGKeyBagAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsTable <Element, Key, ElementOps>::
IGKeyBagAsTable
  (IGKeyBagAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsTable <Element, Key, ElementOps>&
IGKeyBagAsTable <Element, Key, ElementOps>::
operator= (IGKeyBagAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsTable <Element, Key, ElementOps>::
IGKeyBagAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsTable
 <Element, Key, ElementOps>::Implementation&
IGKeyBagAsTable <Element, Key, ElementOps>::
ImplOf (IGKeyBagAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeyBagAsTable
// ---

// public members

template <class Element, class Key>
inline
IKeyBagAsTable <Element, Key>::
IKeyBagAsTable (INumber numberOfElements)
: IGKeyBagAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeyBagAsTable <Element, Key>::
IKeyBagAsTable (PureImplementation& impl)
: IGKeyBagAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeyBagAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsTable <Element, Key, ElementOps>::
IVGKeyBagAsTable (INumber numberOfElements)
: IGKeyBagAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsTable <Element, Key, ElementOps>::
IVGKeyBagAsTable (PureImplementation& impl)
: IGKeyBagAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeyBagAsTable
// ---

// public members

template <class Element, class Key>
inline
IVKeyBagAsTable <Element, Key>::
IVKeyBagAsTable (INumber numberOfElements)
: IVGKeyBagAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeyBagAsTable <Element, Key>::
IVKeyBagAsTable (PureImplementation& impl)
: IVGKeyBagAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
