#ifndef _IKEY_
  #define _IKEY_
/*******************************************************************************
* FILE NAME: ikey.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IKey                                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ibitflag.hpp>


#pragma pack(4)

class IKey : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------ Key Modifiers -------------------------------*/
INESTEDBITFLAGCLASSDEF0( KeyModifier, IKey );
static const KeyModifier
  IC_IMPORTU ctrl,
  IC_IMPORTU alt,
  IC_IMPORTU shift,
  IC_IMPORTU noModifier;

/*------------------------------- Virtual Keys -------------------------------*/
typedef unsigned long
  VirtualKey;
static const VirtualKey
  IC_IMPORTU kEsc,
  IC_IMPORTU kTab,
  IC_IMPORTU kSpace,
  IC_IMPORTU kBackSpace,
  IC_IMPORTU kEnter,
  IC_IMPORTU kNewLine,
  IC_IMPORTU kAlt,
  IC_IMPORTU kCtrl,
  IC_IMPORTU kShift,
  IC_IMPORTU kInsert,
  IC_IMPORTU kDelete,
  IC_IMPORTU kHome,
  IC_IMPORTU kEnd,
  IC_IMPORTU kPageUp,
  IC_IMPORTU kPageDown,
  IC_IMPORTU kLeft,
  IC_IMPORTU kRight,
  IC_IMPORTU kUp,
  IC_IMPORTU kDown,
  IC_IMPORTU kCapsLock,
  IC_IMPORTU kNumLock,
  IC_IMPORTU kScrollLock,
  IC_IMPORTU kPause,
  IC_IMPORTU kBreak,
  IC_IMPORTU kF1,
  IC_IMPORTU kF2,
  IC_IMPORTU kF3,
  IC_IMPORTU kF4,
  IC_IMPORTU kF5,
  IC_IMPORTU kF6,
  IC_IMPORTU kF7,
  IC_IMPORTU kF8,
  IC_IMPORTU kF9,
  IC_IMPORTU kF10,
  IC_IMPORTU kF11,
  IC_IMPORTU kF12,
  IC_IMPORTU kF13,
  IC_IMPORTU kF14,
  IC_IMPORTU kF15,
  IC_IMPORTU kF16,
  IC_IMPORTU kF17,
  IC_IMPORTU kF18,
  IC_IMPORTU kF19,
  IC_IMPORTU kF20,
  IC_IMPORTU kF21,
  IC_IMPORTU kF22,
  IC_IMPORTU kF23,
  IC_IMPORTU kF24,
  IC_IMPORTU kNoKey;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IKey       ( );
  IKey       ( const IKey& key );
IKey
 &operator = ( const IKey& key );
};  // IKey

#pragma pack()

#endif /* _IKEY_ */
