#ifndef _IKEYHDR_
  #define _IKEYHDR_
/*******************************************************************************
* FILE NAME: ikeyhdr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IKeyboardHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ikeyevt.hpp>

#pragma pack(4)

class IKeyboardHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------ Constructors --------------------------------*/
  IKeyboardHandler     ( );
virtual
 ~IKeyboardHandler     ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  scanCodeKeyPress     ( IKeyboardEvent& event ),
  virtualKeyPress      ( IKeyboardEvent& event ),
  characterKeyPress    ( IKeyboardEvent& event ),
  key                  ( IKeyboardEvent& event );

private:
unsigned long
  fKeyStateFlag;
char
  fDiacriticKey;
}; // IKeyboardHandler

#pragma info(nocpy)

template <class ATarget>
class IKeyboardConnectionTo : public IKeyboardHandler {
typedef IKeyboardHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef Boolean  (ATarget::* KeyboardMemberFn)( IKeyboardEvent& );

/*------------------------------- Constructors -------------------------------*/
  IKeyboardConnectionTo ( ATarget&           target,
                          KeyboardMemberFn   characterKeyMemberFn );
virtual
 ~IKeyboardConnectionTo ( );

/*-------------------------- Function Registration ---------------------------*/
IKeyboardConnectionTo<ATarget>
 &setVirtualKeyMemberFn  ( KeyboardMemberFn virtualKeyMemberFn );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  virtualKeyPress      ( IKeyboardEvent& event ),
  characterKeyPress    ( IKeyboardEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
KeyboardMemberFn
  fConnectedCharacterKeyMember,
  fConnectedVirtualKeyMember;
}; // IKeyboardConnectionTo


#ifndef __TEMPINC__
  #include <ikeyhdr.c>
#endif

#pragma info(restore)

#pragma pack()

#endif /* _IKEYHDR_ */
