/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedBagCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagCursor <Element, Key, ElementOps>::
IGKeySortedBagCursor
  (IGKeySortedBag
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagCursor <Element, Key, ElementOps>&
IGKeySortedBagCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedBagCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagCursor <Element, Key, ElementOps>::
IGKeySortedBagCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedBag
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBag <Element, Key, ElementOps>::
IGKeySortedBag (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBag <Element, Key, ElementOps>::
IGKeySortedBag
  (IGKeySortedBag
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBag <Element, Key, ElementOps>&
IGKeySortedBag <Element, Key, ElementOps>::
operator= (IGKeySortedBag
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBag <Element, Key, ElementOps>::
IGKeySortedBag (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBag
 <Element, Key, ElementOps>::Implementation&
IGKeySortedBag <Element, Key, ElementOps>::
ImplOf (IGKeySortedBag
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedBag
// ---

// public members

template <class Element, class Key>
inline
IKeySortedBag <Element, Key>::
IKeySortedBag (INumber numberOfElements)
: IGKeySortedBag
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedBag <Element, Key>::
IKeySortedBag (PureImplementation& impl)
: IGKeySortedBag
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedBag
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBag <Element, Key, ElementOps>::
IVGKeySortedBag (INumber numberOfElements)
: IGKeySortedBag
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBag <Element, Key, ElementOps>::
IVGKeySortedBag (PureImplementation& impl)
: IGKeySortedBag
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedBag
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedBag <Element, Key>::
IVKeySortedBag (INumber numberOfElements)
: IVGKeySortedBag
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedBag <Element, Key>::
IVKeySortedBag (PureImplementation& impl)
: IVGKeySortedBag
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
