/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedBagAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsDilTableCursor <Element, Key, ElementOps>::
IGKeySortedBagAsDilTableCursor
  (IGKeySortedBagAsDilTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsDilTableCursor <Element, Key, ElementOps>&
IGKeySortedBagAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedBagAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsDilTableCursor <Element, Key, ElementOps>::
IGKeySortedBagAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedBagAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsDilTable <Element, Key, ElementOps>::
IGKeySortedBagAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsDilTable <Element, Key, ElementOps>::
IGKeySortedBagAsDilTable
  (IGKeySortedBagAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsDilTable <Element, Key, ElementOps>&
IGKeySortedBagAsDilTable <Element, Key, ElementOps>::
operator= (IGKeySortedBagAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsDilTable <Element, Key, ElementOps>::
IGKeySortedBagAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGKeySortedBagAsDilTable <Element, Key, ElementOps>::
ImplOf (IGKeySortedBagAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedBagAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IKeySortedBagAsDilTable <Element, Key>::
IKeySortedBagAsDilTable (INumber numberOfElements)
: IGKeySortedBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedBagAsDilTable <Element, Key>::
IKeySortedBagAsDilTable (PureImplementation& impl)
: IGKeySortedBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedBagAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBagAsDilTable <Element, Key, ElementOps>::
IVGKeySortedBagAsDilTable (INumber numberOfElements)
: IGKeySortedBagAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBagAsDilTable <Element, Key, ElementOps>::
IVGKeySortedBagAsDilTable (PureImplementation& impl)
: IGKeySortedBagAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedBagAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedBagAsDilTable <Element, Key>::
IVKeySortedBagAsDilTable (INumber numberOfElements)
: IVGKeySortedBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedBagAsDilTable <Element, Key>::
IVKeySortedBagAsDilTable (PureImplementation& impl)
: IVGKeySortedBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
