/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSBLST_H
#define _IKSBLST_H

#include <iaksb.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsList;

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedBagAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagAsListCursor
                            (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsList :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBagAsList <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedBagAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedBagAsList
                            (INumber = 100);

           IGKeySortedBagAsList
                            (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsList <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBagAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedBagAsList :
  public IGKeySortedBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedBagAsList <Element, Key> Self;

#define IKeySortedBagAsListTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedBagAsList
                            (INumber = 100);


protected:

           IKeySortedBagAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedBagAsList :
  public IGKeySortedBagAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBagAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagAsListTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedBagAsList
                            (INumber = 100);


protected:

           IVGKeySortedBagAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedBagAsList :
  public IVGKeySortedBagAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBagAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedBagAsList <Element, Key> Self;

#define IVKeySortedBagAsListTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedBagAsList
                            (INumber = 100);


protected:

           IVKeySortedBagAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksblst.inl>

#pragma info (restore)
#pragma pack ()

#endif
