/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedBagAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsListCursor <Element, Key, ElementOps>::
IGKeySortedBagAsListCursor
  (IGKeySortedBagAsList
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsListCursor <Element, Key, ElementOps>&
IGKeySortedBagAsListCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedBagAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsListCursor <Element, Key, ElementOps>::
IGKeySortedBagAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedBagAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsList <Element, Key, ElementOps>::
IGKeySortedBagAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsList <Element, Key, ElementOps>::
IGKeySortedBagAsList
  (IGKeySortedBagAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsList <Element, Key, ElementOps>&
IGKeySortedBagAsList <Element, Key, ElementOps>::
operator= (IGKeySortedBagAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsList <Element, Key, ElementOps>::
IGKeySortedBagAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsList
 <Element, Key, ElementOps>::Implementation&
IGKeySortedBagAsList <Element, Key, ElementOps>::
ImplOf (IGKeySortedBagAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedBagAsList
// ---

// public members

template <class Element, class Key>
inline
IKeySortedBagAsList <Element, Key>::
IKeySortedBagAsList (INumber numberOfElements)
: IGKeySortedBagAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedBagAsList <Element, Key>::
IKeySortedBagAsList (PureImplementation& impl)
: IGKeySortedBagAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedBagAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBagAsList <Element, Key, ElementOps>::
IVGKeySortedBagAsList (INumber numberOfElements)
: IGKeySortedBagAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBagAsList <Element, Key, ElementOps>::
IVGKeySortedBagAsList (PureImplementation& impl)
: IGKeySortedBagAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedBagAsList
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedBagAsList <Element, Key>::
IVKeySortedBagAsList (INumber numberOfElements)
: IVGKeySortedBagAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedBagAsList <Element, Key>::
IVKeySortedBagAsList (PureImplementation& impl)
: IVGKeySortedBagAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
