/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSBST_H
#define _IKSBST_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iiksbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySetAsBstTree;

template <class Element, class Key, class ElementOps>
class IGKeySetAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySetAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsBstTreeCursor
                            (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySetAsBstTree :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsBstTree <Element, Key, ElementOps> Self;

  typedef  IKeySetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySetAsBstTree
                            (INumber = 100);

           IGKeySetAsBstTree
                            (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsBstTree <Element, Key, ElementOps>&
           operator=        (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsBstTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySetAsBstTree :
  public IGKeySetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySetAsBstTree <Element, Key> Self;

#define IKeySetAsBstTreeTypedef(Element, Key)\
  typedef  IKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySetAsBstTree
                            (INumber = 100);


protected:

           IKeySetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySetAsBstTree :
  public IGKeySetAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsBstTreeTypedef (Element, Key, ElementOps);

public:

           IVGKeySetAsBstTree
                            (INumber = 100);


protected:

           IVGKeySetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySetAsBstTree :
  public IVGKeySetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySetAsBstTree <Element, Key> Self;

#define IVKeySetAsBstTreeTypedef(Element, Key)\
  typedef  IVKeySetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySetAsBstTree
                            (INumber = 100);


protected:

           IVKeySetAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
