/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSHSH_H
#define _IKSHSH_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iikshsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySetAsHshTable;

template <class Element, class Key, class ElementOps>
class IGKeySetAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySetAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsHshTableCursor
                            (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsHshTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySetAsHshTable :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsHshTable <Element, Key, ElementOps> Self;

  typedef  IKeySetAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetAsHshTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySetAsHshTable
                            (INumber = 100);

           IGKeySetAsHshTable
                            (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsHshTable <Element, Key, ElementOps>&
           operator=        (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySetAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsHshTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySetAsHshTable :
  public IGKeySetAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IGKeySetAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef  IKeySetAsHshTable <Element, Key> Self;

#define IKeySetAsHshTableTypedef(Element, Key)\
  typedef  IKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySetAsHshTable
                            (INumber = 100);


protected:

           IKeySetAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySetAsHshTable :
  public IGKeySetAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsHshTableTypedef (Element, Key, ElementOps);

public:

           IVGKeySetAsHshTable
                            (INumber = 100);


protected:

           IVGKeySetAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySetAsHshTable :
  public IVGKeySetAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IVGKeySetAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySetAsHshTable <Element, Key> Self;

#define IVKeySetAsHshTableTypedef(Element, Key)\
  typedef  IVKeySetAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySetAsHshTable
                            (INumber = 100);


protected:

           IVKeySetAsHshTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikshsh.inl>

#pragma info (restore)
#pragma pack ()

#endif
