/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSLST_H
#define _IKSLST_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iikslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySetAsList;

template <class Element, class Key, class ElementOps>
class IGKeySetAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySetAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsListCursor
                            (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySetAsList :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsList <Element, Key, ElementOps> Self;

  typedef  IKeySetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySetAsList
                            (INumber = 100);

           IGKeySetAsList
                            (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsList <Element, Key, ElementOps>&
           operator=        (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySetAsList :
  public IGKeySetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySetAsList <Element, Key> Self;

#define IKeySetAsListTypedef(Element, Key)\
  typedef  IKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySetAsList
                            (INumber = 100);


protected:

           IKeySetAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySetAsList :
  public IGKeySetAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsListTypedef (Element, Key, ElementOps);

public:

           IVGKeySetAsList
                            (INumber = 100);


protected:

           IVGKeySetAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySetAsList :
  public IVGKeySetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySetAsList <Element, Key> Self;

#define IVKeySetAsListTypedef(Element, Key)\
  typedef  IVKeySetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySetAsList
                            (INumber = 100);


protected:

           IVKeySetAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikslst.inl>

#pragma info (restore)
#pragma pack ()

#endif
