/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsListCursor <Element, Key, ElementOps>::
IGKeySetAsListCursor
  (IGKeySetAsList
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsListCursor <Element, Key, ElementOps>&
IGKeySetAsListCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsListCursor <Element, Key, ElementOps>::
IGKeySetAsListCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySetAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsList <Element, Key, ElementOps>::
IGKeySetAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsList <Element, Key, ElementOps>::
IGKeySetAsList
  (IGKeySetAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsList <Element, Key, ElementOps>&
IGKeySetAsList <Element, Key, ElementOps>::
operator= (IGKeySetAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsList <Element, Key, ElementOps>::
IGKeySetAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsList
 <Element, Key, ElementOps>::Implementation&
IGKeySetAsList <Element, Key, ElementOps>::
ImplOf (IGKeySetAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySetAsList
// ---

// public members

template <class Element, class Key>
inline
IKeySetAsList <Element, Key>::
IKeySetAsList (INumber numberOfElements)
: IGKeySetAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySetAsList <Element, Key>::
IKeySetAsList (PureImplementation& impl)
: IGKeySetAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySetAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsList <Element, Key, ElementOps>::
IVGKeySetAsList (INumber numberOfElements)
: IGKeySetAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsList <Element, Key, ElementOps>::
IVGKeySetAsList (PureImplementation& impl)
: IGKeySetAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySetAsList
// ---

// public members

template <class Element, class Key>
inline
IVKeySetAsList <Element, Key>::
IVKeySetAsList (INumber numberOfElements)
: IVGKeySetAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySetAsList <Element, Key>::
IVKeySetAsList (PureImplementation& impl)
: IVGKeySetAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
