/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedSetCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetCursor <Element, Key, ElementOps>::
IGKeySortedSetCursor
  (IGKeySortedSet
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetCursor <Element, Key, ElementOps>&
IGKeySortedSetCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedSetCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetCursor <Element, Key, ElementOps>::
IGKeySortedSetCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedSet
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSet <Element, Key, ElementOps>::
IGKeySortedSet (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSet <Element, Key, ElementOps>::
IGKeySortedSet
  (IGKeySortedSet
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSet <Element, Key, ElementOps>&
IGKeySortedSet <Element, Key, ElementOps>::
operator= (IGKeySortedSet
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSet <Element, Key, ElementOps>::
IGKeySortedSet (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSet
 <Element, Key, ElementOps>::Implementation&
IGKeySortedSet <Element, Key, ElementOps>::
ImplOf (IGKeySortedSet
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedSet
// ---

// public members

template <class Element, class Key>
inline
IKeySortedSet <Element, Key>::
IKeySortedSet (INumber numberOfElements)
: IGKeySortedSet
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedSet <Element, Key>::
IKeySortedSet (PureImplementation& impl)
: IGKeySortedSet
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedSet
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSet <Element, Key, ElementOps>::
IVGKeySortedSet (INumber numberOfElements)
: IGKeySortedSet
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSet <Element, Key, ElementOps>::
IVGKeySortedSet (PureImplementation& impl)
: IGKeySortedSet
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedSet
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedSet <Element, Key>::
IVKeySortedSet (INumber numberOfElements)
: IVGKeySortedSet
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedSet <Element, Key>::
IVKeySortedSet (PureImplementation& impl)
: IVGKeySortedSet
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
