/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedSetAsAvlTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>::
IGKeySortedSetAsAvlTreeCursor
  (IGKeySortedSetAsAvlTree
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>&
IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedSetAsAvlTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>::
IGKeySortedSetAsAvlTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedSetAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
IGKeySortedSetAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
IGKeySortedSetAsAvlTree
  (IGKeySortedSetAsAvlTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsAvlTree <Element, Key, ElementOps>&
IGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
operator= (IGKeySortedSetAsAvlTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
IGKeySortedSetAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsAvlTree
 <Element, Key, ElementOps>::Implementation&
IGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
ImplOf (IGKeySortedSetAsAvlTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedSetAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IKeySortedSetAsAvlTree <Element, Key>::
IKeySortedSetAsAvlTree (INumber numberOfElements)
: IGKeySortedSetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedSetAsAvlTree <Element, Key>::
IKeySortedSetAsAvlTree (PureImplementation& impl)
: IGKeySortedSetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedSetAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
IVGKeySortedSetAsAvlTree (INumber numberOfElements)
: IGKeySortedSetAsAvlTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsAvlTree <Element, Key, ElementOps>::
IVGKeySortedSetAsAvlTree (PureImplementation& impl)
: IGKeySortedSetAsAvlTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedSetAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedSetAsAvlTree <Element, Key>::
IVKeySortedSetAsAvlTree (INumber numberOfElements)
: IVGKeySortedSetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedSetAsAvlTree <Element, Key>::
IVKeySortedSetAsAvlTree (PureImplementation& impl)
: IVGKeySortedSetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
