/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedSetAsBstTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>::
IGKeySortedSetAsBstTreeCursor
  (IGKeySortedSetAsBstTree
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>&
IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedSetAsBstTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>::
IGKeySortedSetAsBstTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedSetAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsBstTree <Element, Key, ElementOps>::
IGKeySortedSetAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsBstTree <Element, Key, ElementOps>::
IGKeySortedSetAsBstTree
  (IGKeySortedSetAsBstTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsBstTree <Element, Key, ElementOps>&
IGKeySortedSetAsBstTree <Element, Key, ElementOps>::
operator= (IGKeySortedSetAsBstTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsBstTree <Element, Key, ElementOps>::
IGKeySortedSetAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsBstTree
 <Element, Key, ElementOps>::Implementation&
IGKeySortedSetAsBstTree <Element, Key, ElementOps>::
ImplOf (IGKeySortedSetAsBstTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedSetAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IKeySortedSetAsBstTree <Element, Key>::
IKeySortedSetAsBstTree (INumber numberOfElements)
: IGKeySortedSetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedSetAsBstTree <Element, Key>::
IKeySortedSetAsBstTree (PureImplementation& impl)
: IGKeySortedSetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedSetAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsBstTree <Element, Key, ElementOps>::
IVGKeySortedSetAsBstTree (INumber numberOfElements)
: IGKeySortedSetAsBstTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsBstTree <Element, Key, ElementOps>::
IVGKeySortedSetAsBstTree (PureImplementation& impl)
: IGKeySortedSetAsBstTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedSetAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedSetAsBstTree <Element, Key>::
IVKeySortedSetAsBstTree (INumber numberOfElements)
: IVGKeySortedSetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedSetAsBstTree <Element, Key>::
IVKeySortedSetAsBstTree (PureImplementation& impl)
: IVGKeySortedSetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
