/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSSDIL_H
#define _IKSSDIL_H

#include <iakss.h>
#include <iickss.h>
#include <iivkss.h>
#include <iikssdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsDilTable;

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedSetAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsDilTableCursor
                            (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsDilTable :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedSetAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedSetAsDilTable
                            (INumber = 100);

           IGKeySortedSetAsDilTable
                            (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedSetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedSetAsDilTable :
  public IGKeySortedSetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedSetAsDilTable <Element, Key> Self;

#define IKeySortedSetAsDilTableTypedef(Element, Key)\
  typedef  IKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedSetAsDilTable
                            (INumber = 100);


protected:

           IKeySortedSetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsDilTable :
  public IGKeySortedSetAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedSetAsDilTable
                            (INumber = 100);


protected:

           IVGKeySortedSetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedSetAsDilTable :
  public IVGKeySortedSetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedSetAsDilTable <Element, Key> Self;

#define IVKeySortedSetAsDilTableTypedef(Element, Key)\
  typedef  IVKeySortedSetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedSetAsDilTable
                            (INumber = 100);


protected:

           IVKeySortedSetAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikssdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
