/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedSetAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>::
IGKeySortedSetAsDilTableCursor
  (IGKeySortedSetAsDilTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>&
IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedSetAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsDilTableCursor <Element, Key, ElementOps>::
IGKeySortedSetAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedSetAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsDilTable <Element, Key, ElementOps>::
IGKeySortedSetAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsDilTable <Element, Key, ElementOps>::
IGKeySortedSetAsDilTable
  (IGKeySortedSetAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsDilTable <Element, Key, ElementOps>&
IGKeySortedSetAsDilTable <Element, Key, ElementOps>::
operator= (IGKeySortedSetAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsDilTable <Element, Key, ElementOps>::
IGKeySortedSetAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGKeySortedSetAsDilTable <Element, Key, ElementOps>::
ImplOf (IGKeySortedSetAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedSetAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IKeySortedSetAsDilTable <Element, Key>::
IKeySortedSetAsDilTable (INumber numberOfElements)
: IGKeySortedSetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedSetAsDilTable <Element, Key>::
IKeySortedSetAsDilTable (PureImplementation& impl)
: IGKeySortedSetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedSetAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsDilTable <Element, Key, ElementOps>::
IVGKeySortedSetAsDilTable (INumber numberOfElements)
: IGKeySortedSetAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsDilTable <Element, Key, ElementOps>::
IVGKeySortedSetAsDilTable (PureImplementation& impl)
: IGKeySortedSetAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedSetAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedSetAsDilTable <Element, Key>::
IVKeySortedSetAsDilTable (INumber numberOfElements)
: IVGKeySortedSetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedSetAsDilTable <Element, Key>::
IVKeySortedSetAsDilTable (PureImplementation& impl)
: IVGKeySortedSetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
