/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedSetAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsListCursor <Element, Key, ElementOps>::
IGKeySortedSetAsListCursor
  (IGKeySortedSetAsList
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsListCursor <Element, Key, ElementOps>&
IGKeySortedSetAsListCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedSetAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsListCursor <Element, Key, ElementOps>::
IGKeySortedSetAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedSetAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsList <Element, Key, ElementOps>::
IGKeySortedSetAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsList <Element, Key, ElementOps>::
IGKeySortedSetAsList
  (IGKeySortedSetAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsList <Element, Key, ElementOps>&
IGKeySortedSetAsList <Element, Key, ElementOps>::
operator= (IGKeySortedSetAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsList <Element, Key, ElementOps>::
IGKeySortedSetAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsList
 <Element, Key, ElementOps>::Implementation&
IGKeySortedSetAsList <Element, Key, ElementOps>::
ImplOf (IGKeySortedSetAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedSetAsList
// ---

// public members

template <class Element, class Key>
inline
IKeySortedSetAsList <Element, Key>::
IKeySortedSetAsList (INumber numberOfElements)
: IGKeySortedSetAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedSetAsList <Element, Key>::
IKeySortedSetAsList (PureImplementation& impl)
: IGKeySortedSetAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedSetAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsList <Element, Key, ElementOps>::
IVGKeySortedSetAsList (INumber numberOfElements)
: IGKeySortedSetAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsList <Element, Key, ElementOps>::
IVGKeySortedSetAsList (PureImplementation& impl)
: IGKeySortedSetAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedSetAsList
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedSetAsList <Element, Key>::
IVKeySortedSetAsList (INumber numberOfElements)
: IVGKeySortedSetAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedSetAsList <Element, Key>::
IVKeySortedSetAsList (PureImplementation& impl)
: IVGKeySortedSetAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
