/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSSTAB_H
#define _IKSSTAB_H

#include <iakss.h>
#include <iickss.h>
#include <iivkss.h>
#include <iiksstab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsTable;

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedSetAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsTableCursor
                            (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsTable :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedSetAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedSetAsTable
                            (INumber = 100);

           IGKeySortedSetAsTable
                            (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedSetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedSetAsTable :
  public IGKeySortedSetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedSetAsTable <Element, Key> Self;

#define IKeySortedSetAsTableTypedef(Element, Key)\
  typedef  IKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedSetAsTable
                            (INumber = 100);


protected:

           IKeySortedSetAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsTable :
  public IGKeySortedSetAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsTableTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedSetAsTable
                            (INumber = 100);


protected:

           IVGKeySortedSetAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedSetAsTable :
  public IVGKeySortedSetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedSetAsTable <Element, Key> Self;

#define IVKeySortedSetAsTableTypedef(Element, Key)\
  typedef  IVKeySortedSetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedSetAsTable
                            (INumber = 100);


protected:

           IVKeySortedSetAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksstab.inl>

#pragma info (restore)
#pragma pack ()

#endif
