/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedSetAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsTableCursor <Element, Key, ElementOps>::
IGKeySortedSetAsTableCursor
  (IGKeySortedSetAsTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsTableCursor <Element, Key, ElementOps>&
IGKeySortedSetAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedSetAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsTableCursor <Element, Key, ElementOps>::
IGKeySortedSetAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedSetAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsTable <Element, Key, ElementOps>::
IGKeySortedSetAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsTable <Element, Key, ElementOps>::
IGKeySortedSetAsTable
  (IGKeySortedSetAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsTable <Element, Key, ElementOps>&
IGKeySortedSetAsTable <Element, Key, ElementOps>::
operator= (IGKeySortedSetAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedSetAsTable <Element, Key, ElementOps>::
IGKeySortedSetAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedSetAsTable
 <Element, Key, ElementOps>::Implementation&
IGKeySortedSetAsTable <Element, Key, ElementOps>::
ImplOf (IGKeySortedSetAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedSetAsTable
// ---

// public members

template <class Element, class Key>
inline
IKeySortedSetAsTable <Element, Key>::
IKeySortedSetAsTable (INumber numberOfElements)
: IGKeySortedSetAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedSetAsTable <Element, Key>::
IKeySortedSetAsTable (PureImplementation& impl)
: IGKeySortedSetAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedSetAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsTable <Element, Key, ElementOps>::
IVGKeySortedSetAsTable (INumber numberOfElements)
: IGKeySortedSetAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedSetAsTable <Element, Key, ElementOps>::
IVGKeySortedSetAsTable (PureImplementation& impl)
: IGKeySortedSetAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedSetAsTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedSetAsTable <Element, Key>::
IVKeySortedSetAsTable (INumber numberOfElements)
: IVGKeySortedSetAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedSetAsTable <Element, Key>::
IVKeySortedSetAsTable (PureImplementation& impl)
: IVGKeySortedSetAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
