/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSTAB_H
#define _IKSTAB_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iikstab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySetAsTable;

template <class Element, class Key, class ElementOps>
class IGKeySetAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySetAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsTableCursor
                            (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySetAsTable :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySetAsTable
                            (INumber = 100);

           IGKeySetAsTable
                            (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsTable <Element, Key, ElementOps>&
           operator=        (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySetAsTable :
  public IGKeySetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySetAsTable <Element, Key> Self;

#define IKeySetAsTableTypedef(Element, Key)\
  typedef  IKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySetAsTable
                            (INumber = 100);


protected:

           IKeySetAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySetAsTable :
  public IGKeySetAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsTableTypedef (Element, Key, ElementOps);

public:

           IVGKeySetAsTable
                            (INumber = 100);


protected:

           IVGKeySetAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySetAsTable :
  public IVGKeySetAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySetAsTable <Element, Key> Self;

#define IVKeySetAsTableTypedef(Element, Key)\
  typedef  IVKeySetAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySetAsTable
                            (INumber = 100);


protected:

           IVKeySetAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikstab.inl>

#pragma info (restore)
#pragma pack ()

#endif
