#ifndef _ILISTBAS_
  #define _ILISTBAS_
/*******************************************************************************
* FILE NAME: ilistbas.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBaseListBox                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <irect.hpp>

class IString;
class IResourceId;
class IBaseListBoxData;
class IBaseListBoxCursorData;

#pragma pack(4)

class IBaseListBox : public IControl {
typedef IControl
  Inherited;
public:
class Style;
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IBaseListBox   ( unsigned long        id,
                   IWindow*             parent,
                   IWindow*             owner,
                   const IRectangle&    initial = IRectangle  ( ),
                   const Style&         style   = defaultStyle( ) );

  IBaseListBox   ( unsigned long        id,
                   IWindow*             parent );

  IBaseListBox   ( const IWindowHandle& handle );

virtual
 ~IBaseListBox   ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IBaseListBox, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU drawItem,
  IC_IMPORTU horizontalScroll,
  IC_IMPORTU multipleSelect,
  IC_IMPORTU extendedSelect;
static const Style
  IC_IMPORTU noAdjustPosition;
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle            ( );

static void
  setDefaultStyle         ( const Style&    style );

virtual unsigned long
  convertToGUIStyle       ( const IBitFlag& style,
                            Boolean         extendedOnly = false ) const;

Boolean
  isDrawItem              ( ) const,
  isHorizontalScroll      ( ) const,
  isMultipleSelect        ( ) const,
  isExtendedSelect        ( ) const;
Boolean
  isNoAdjustPosition      ( ) const;

virtual IBaseListBox
 &enableDrawItem          ( Boolean enable = true ),
 &disableDrawItem         ( );

#ifndef IC_WIN_FLAGNOP
virtual IBaseListBox
 &enableMultipleSelect    ( Boolean enable = true ),
 &disableMultipleSelect   ( ),
 &enableExtendedSelect    ( Boolean enable = true ),
 &disableExtendedSelect   ( );
#endif

virtual IBaseListBox
 &enableNoAdjustPosition  ( Boolean enable = true ),
 &disableNoAdjustPosition ( );

/*------------------------- Get and Change Items -----------------------------*/
virtual IString
  itemText                ( unsigned long      index ) const;

virtual IBaseListBox
 &setItemText             ( unsigned long      index,
                            const char*        string ),
 &setItemText             ( unsigned long      index,
                            const IResourceId& string );

virtual IString
  elementAt               ( const Cursor&      cursor ) const;

/*------------------------- Selection ----------------------------------------*/
virtual IBaseListBox
 &select                  ( unsigned long index,
                            Boolean       select = true ),
 &deselect                ( unsigned long index ),
 &selectAll               ( ),
 &deselectAll             ( );

virtual Boolean
  isSelected              ( unsigned long index ) const;

virtual unsigned long
  numberOfSelections      ( ) const;

virtual long
  selection               ( ) const;

/*------------------------ Scrolling Members ---------------------------------*/
virtual IBaseListBox
 &setTop                  ( unsigned long index );

virtual unsigned long
  top                     ( ) const;

/*------------------------ Handle Members ------------------------------------*/
virtual IBaseListBox
 &setItemHandle           ( unsigned long index,
                            unsigned long handle );

virtual unsigned long
  itemHandle              ( unsigned long index ) const;

/*------------------------ Search List ---------------------------------------*/
enum SearchType {
  prefix,
  substring,
  exactMatch
};

static const unsigned long
  IC_IMPORTU notFound,
  IC_IMPORTU first;

virtual unsigned long
  locateText              ( const char*   searchString,
                            Boolean       caseSensitive = true,
                            SearchType    search        = exactMatch,
                            unsigned long index         = first ) const;

/*------------------------- Content ------------------------------------------*/
virtual unsigned long
  count                   ( ) const;

virtual Boolean
  isEmpty                 ( ) const;

/*------------------------- Item Height --------------------------------------*/
virtual IBaseListBox
 &setItemHeight           ( unsigned long newHeight );

unsigned long
  itemHeight              ( ) const;



class Cursor : public IVBase {
public:
/*------------------------------ Filters --------------------------------*/
enum Filter {
  selectedItems,
  allItems
};

/*---------------------------- Constructors -----------------------------*/
  Cursor                  ( const IBaseListBox& listbox,
                            Filter              type = selectedItems );

virtual
 ~Cursor                  ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual Boolean
  setToFirst              ( ),
  setToNext               ( ),
  setToPrevious           ( ),
  setToLast               ( ),
  setToIndex              ( unsigned long index );

/*-------------------------- Cursor Validation --------------------------*/
virtual Boolean
  isValid                 ( ) const;

virtual void
  invalidate              ( );

virtual unsigned long
  asIndex                 ( ) const;

private:
/*-------------------------- Hidden Members -----------------------------*/
  Cursor                  ( const Cursor& cursor );
Cursor
 &operator=               ( const Cursor& cursor );

/*------------------------------- Private -------------------------------*/
const IBaseListBox
 &rlbCl;
unsigned long
  lClCurrent;
Filter
  cursorTypeCl;
unsigned long
  sameValidation;

IBaseListBoxCursorData
 *fCursorData;
}; // IBaseListBox::Cursor

/*------------------------- Color --------------------------------------------*/
virtual IColor
  backgroundColor         ( ) const;

/*------------------------- Layout Support -----------------------------------*/
virtual IBaseListBox
 &setLayoutDistorted      ( unsigned long layoutAttributesOn,
                            unsigned long layoutAttributesOff ),
 &setMinimumCharacters    ( unsigned long minimumCharacters ),
 &setMinimumRows          ( unsigned long minimumRows );

unsigned long
  minimumCharacters       ( ) const,
  minimumRows             ( ) const;

IBaseListBox&
  enableHorizontalScrollbarSizing( Boolean bEnable );       // defect 29260

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU enterId,
  IC_IMPORTU selectId;

virtual IBaseListBox
 &enableNotification      ( Boolean enable = true );

protected:
/*------------------------- Layout Support -----------------------------------*/
virtual ISize
  calcMinimumSize         ( ) const;


/*------------------------------- Item Changes -------------------------------*/
unsigned long
  changeCount             ( ) const;

void
  incrementChangeCount    ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IBaseListBox            ( const IBaseListBox& listBox );
IBaseListBox
 &operator=               ( const IBaseListBox& listBox );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseListBox::Cursor;
friend class IBaseListHandler;


static Style
  currentDefaultStyle;

unsigned long
  needValidation;

IBaseListBoxData
 *fBaseListBoxData;
}; // IBaseListBox

INESTEDBITFLAGCLASSFUNCS(Style, IBaseListBox);

#pragma pack()

#endif  /* _ILISTBAS_ */
