/*******************************************************************************
* FILE NAME: ilistcvw.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ilistcvw.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include  <icollvwi.hpp>
#include  <ilistcvw.hpp>
#include  <icolvwd.hpp>
#include  <iseq.h>
#include  <ipartccl.h>


template <class Element, class Collection>
  const unsigned long
    ICollectionViewListBox<Element, Collection>::noSelection = 0;


template <class Element, class Collection>
  class ICollectionViewListBoxData : public IBase {

public:

  ICollectionViewListBoxData( const IStringGenerator<Element>& stringGenerator );

 ~ICollectionViewListBoxData ( );

ICollectionViewData< Element,
                     ICollectionViewListBox< Element, Collection >,
                     Collection >
 *fCollectionViewData;

Boolean saveSelectionState;

private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionViewListBoxData
             ( const ICollectionViewListBoxData< Element, Collection >& source );
ICollectionViewListBoxData<Element,Collection>
 &operator=  ( const ICollectionViewListBoxData< Element, Collection >& source );

};


template <class Element, class Collection>
  ICollectionViewListBoxData<Element, Collection>::
    ICollectionViewListBoxData( const IStringGenerator<Element>& stringGenerator )
      : saveSelectionState( false )
{
  fCollectionViewData = new
        ICollectionViewData< Element,
                             ICollectionViewListBox< Element, Collection >,
                             Collection > ( stringGenerator) ;
}

template <class Element, class Collection>
  ICollectionViewListBoxData<Element,Collection>::
   ~ICollectionViewListBoxData ( )
{
  delete fCollectionViewData;
}


template <class Element, class Collection>
  ICollectionViewListBox<Element,Collection>::
    ICollectionViewListBox ( unsigned long                    identifier,
                             IWindow*                         parent,
                             IWindow*                         owner ,
                             const IRectangle&                initial,
                             const IBaseListBox::Style&       style,
                             const IStringGenerator<Element>& stringGenerator )
    : IBaseListBox( identifier, parent, owner, initial, style )
{
  fCollectionViewListBoxData = new ICollectionViewListBoxData<Element, Collection>( stringGenerator );
  fCollectionViewListBoxData->fCollectionViewData->fCollectionObserver.setViewer( this );
  enableNotification();
}


template <class Element, class Collection>
  ICollectionViewListBox<Element,Collection>::
    ICollectionViewListBox ( unsigned long                    identifier,
                             IWindow*                         parent,
                             const IStringGenerator<Element>& stringGenerator )
    : IBaseListBox( identifier, parent )
{
  fCollectionViewListBoxData = new ICollectionViewListBoxData<Element, Collection>( stringGenerator );
  fCollectionViewListBoxData->fCollectionViewData->fCollectionObserver.setViewer( this );
  enableNotification();
}

template <class Element, class Collection>
  ICollectionViewListBox<Element,Collection>::
    ICollectionViewListBox( const IWindowHandle&             handle,
                            const IStringGenerator<Element>& stringGenerator )
    : IBaseListBox( handle )
{
  fCollectionViewListBoxData = new ICollectionViewListBoxData<Element, Collection>( stringGenerator );
  fCollectionViewListBoxData->fCollectionViewData->fCollectionObserver.setViewer( this );
  enableNotification();
}

template <class Element, class Collection>
  ICollectionViewListBox<Element,Collection>::
   ~ICollectionViewListBox ( )
{
  disableNotification();

  delete fCollectionViewListBoxData;
}


template <class Element, class Collection>
  ICollectionViewListBox<Element, Collection>& ICollectionViewListBox<Element, Collection>::
    selectedElements ( Collection& elements )
{

  IPartOrderedCollection<Element>* pSequence = items();
  ICursor*                         pCursor   = pSequence->newCursor();
  IBaseListBox::Cursor             cursor( *this );//defaults to selected items

  elements.removeAll( );

  forCursor( cursor )
  {
    pSequence->setToPosition( cursor.asIndex()+1, *pCursor );
    elements.add( pSequence->elementAt( *pCursor ));
  }
  delete pCursor;

  return *this;
}


template <class Element, class Collection>
  ICollectionViewListBox<Element, Collection>&
    ICollectionViewListBox<Element, Collection>::
      enableExtendedSelect( Boolean  extended )
{

  if ( extended != IBaseListBox::isExtendedSelect( ) )
  {
    IBaseListBox::enableExtendedSelect ( extended );

    INotificationEvent  anEvent(
         ICollectionViewListBox<Element, Collection>::extendedSelectChangedId,
         *this );
    notifyObservers( anEvent );
  }
  return *this;
}


template <class Element, class Collection>
  INotificationId const ICollectionViewListBox<Element,Collection>::itemChangedId =
    "ICollectionViewListBox::itemChangedId";
template <class Element, class Collection>
  INotificationId const ICollectionViewListBox<Element,Collection>::itemsId =
    "ICollectionViewListBox::itemsId";
template <class Element, class Collection>
  INotificationId const
    ICollectionViewListBox<Element, Collection>::extendedSelectChangedId =
      "ICollectionViewListBox::extendedSelectChangedId";

#include <ilistcv2.c>
