/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAP_H
#define _IMAP_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimapavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMap;

template <class Element, class Key, class ElementOps>
class IGMapCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMap
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapCursor
                            (IGMap
                              <
                               Element, Key, ElementOps> const&);

  IGMapCursor <Element, Key, ElementOps>&
           operator=        (IGMapCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMap :
  public IAMap <Element, Key> {
protected:

  typedef  IGMap <Element, Key, ElementOps> Self;

  typedef  IMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapCursor
            <Element, Key, ElementOps> Cursor;


           IGMap
                            (INumber = 100);

           IGMap
                            (IGMap
                              <
                               Element, Key, ElementOps> const&);

  IGMap <Element, Key, ElementOps>&
           operator=        (IGMap
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMap
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMap
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMap :
  public IGMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IMap <Element, Key> Self;

#define IMapTypedef(Element, Key)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMap
                            (INumber = 100);


protected:

           IMap
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMap :
  public IGMap
          <Element, Key, ElementOps > {

  typedef  IVGMap
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapTypedef (Element, Key, ElementOps);

public:

           IVGMap
                            (INumber = 100);


protected:

           IVGMap
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMap :
  public IVGMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVMap <Element, Key> Self;

#define IVMapTypedef(Element, Key)\
  typedef  IVMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMap
                            (INumber = 100);


protected:

           IVMap
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imap.inl>

#pragma info (restore)
#pragma pack ()

#endif
