/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapCursor <Element, Key, ElementOps>::
IGMapCursor
  (IGMap
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapCursor <Element, Key, ElementOps>&
IGMapCursor <Element, Key, ElementOps>::
operator=
  (IGMapCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapCursor <Element, Key, ElementOps>::
IGMapCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMap
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMap <Element, Key, ElementOps>::
IGMap (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMap <Element, Key, ElementOps>::
IGMap
  (IGMap
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMap <Element, Key, ElementOps>&
IGMap <Element, Key, ElementOps>::
operator= (IGMap
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMap <Element, Key, ElementOps>::
IGMap (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMap
 <Element, Key, ElementOps>::Implementation&
IGMap <Element, Key, ElementOps>::
ImplOf (IGMap
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMap
// ---

// public members

template <class Element, class Key>
inline
IMap <Element, Key>::
IMap (INumber numberOfElements)
: IGMap
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMap <Element, Key>::
IMap (PureImplementation& impl)
: IGMap
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGMap
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMap <Element, Key, ElementOps>::
IVGMap (INumber numberOfElements)
: IGMap
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMap <Element, Key, ElementOps>::
IVGMap (PureImplementation& impl)
: IGMap
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMap
// ---

// public members

template <class Element, class Key>
inline
IVMap <Element, Key>::
IVMap (INumber numberOfElements)
: IVGMap
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMap <Element, Key>::
IVMap (PureImplementation& impl)
: IVGMap
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
