/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAPAVL_H
#define _IMAPAVL_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimapavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMapAsAvlTree;

template <class Element, class Key, class ElementOps>
class IGMapAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMapAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsAvlTreeCursor
                            (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMapAsAvlTree :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsAvlTree <Element, Key, ElementOps> Self;

  typedef  IMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGMapAsAvlTree
                            (INumber = 100);

           IGMapAsAvlTree
                            (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMapAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsAvlTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMapAsAvlTree :
  public IGMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IMapAsAvlTree <Element, Key> Self;

#define IMapAsAvlTreeTypedef(Element, Key)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMapAsAvlTree
                            (INumber = 100);


protected:

           IMapAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMapAsAvlTree :
  public IGMapAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGMapAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

           IVGMapAsAvlTree
                            (INumber = 100);


protected:

           IVGMapAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMapAsAvlTree :
  public IVGMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVMapAsAvlTree <Element, Key> Self;

#define IVMapAsAvlTreeTypedef(Element, Key)\
  typedef  IVMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMapAsAvlTree
                            (INumber = 100);


protected:

           IVMapAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imapavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
