/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAPBST_H
#define _IMAPBST_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimapbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMapAsBstTree;

template <class Element, class Key, class ElementOps>
class IGMapAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMapAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsBstTreeCursor
                            (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMapAsBstTree :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsBstTree <Element, Key, ElementOps> Self;

  typedef  IMapAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGMapAsBstTree
                            (INumber = 100);

           IGMapAsBstTree
                            (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsBstTree <Element, Key, ElementOps>&
           operator=        (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMapAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsBstTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMapAsBstTree :
  public IGMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IMapAsBstTree <Element, Key> Self;

#define IMapAsBstTreeTypedef(Element, Key)\
  typedef  IMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMapAsBstTree
                            (INumber = 100);


protected:

           IMapAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMapAsBstTree :
  public IGMapAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGMapAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

           IVGMapAsBstTree
                            (INumber = 100);


protected:

           IVGMapAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMapAsBstTree :
  public IVGMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVMapAsBstTree <Element, Key> Self;

#define IVMapAsBstTreeTypedef(Element, Key)\
  typedef  IVMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMapAsBstTree
                            (INumber = 100);


protected:

           IVMapAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imapbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
