/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAPDIL_H
#define _IMAPDIL_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimapdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMapAsDilTable;

template <class Element, class Key, class ElementOps>
class IGMapAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMapAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsDilTableCursor
                            (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMapAsDilTable :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsDilTable <Element, Key, ElementOps> Self;

  typedef  IMapAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGMapAsDilTable
                            (INumber = 100);

           IGMapAsDilTable
                            (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsDilTable <Element, Key, ElementOps>&
           operator=        (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMapAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMapAsDilTable :
  public IGMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IMapAsDilTable <Element, Key> Self;

#define IMapAsDilTableTypedef(Element, Key)\
  typedef  IMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMapAsDilTable
                            (INumber = 100);


protected:

           IMapAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMapAsDilTable :
  public IGMapAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGMapAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGMapAsDilTable
                            (INumber = 100);


protected:

           IVGMapAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMapAsDilTable :
  public IVGMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVMapAsDilTable <Element, Key> Self;

#define IVMapAsDilTableTypedef(Element, Key)\
  typedef  IVMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMapAsDilTable
                            (INumber = 100);


protected:

           IVMapAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imapdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
