/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsDilTableCursor <Element, Key, ElementOps>::
IGMapAsDilTableCursor
  (IGMapAsDilTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapAsDilTableCursor <Element, Key, ElementOps>&
IGMapAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGMapAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsDilTableCursor <Element, Key, ElementOps>::
IGMapAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMapAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsDilTable <Element, Key, ElementOps>::
IGMapAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMapAsDilTable <Element, Key, ElementOps>::
IGMapAsDilTable
  (IGMapAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsDilTable <Element, Key, ElementOps>&
IGMapAsDilTable <Element, Key, ElementOps>::
operator= (IGMapAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsDilTable <Element, Key, ElementOps>::
IGMapAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGMapAsDilTable <Element, Key, ElementOps>::
ImplOf (IGMapAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMapAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IMapAsDilTable <Element, Key>::
IMapAsDilTable (INumber numberOfElements)
: IGMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMapAsDilTable <Element, Key>::
IMapAsDilTable (PureImplementation& impl)
: IGMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGMapAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsDilTable <Element, Key, ElementOps>::
IVGMapAsDilTable (INumber numberOfElements)
: IGMapAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsDilTable <Element, Key, ElementOps>::
IVGMapAsDilTable (PureImplementation& impl)
: IGMapAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMapAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVMapAsDilTable <Element, Key>::
IVMapAsDilTable (INumber numberOfElements)
: IVGMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMapAsDilTable <Element, Key>::
IVMapAsDilTable (PureImplementation& impl)
: IVGMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
