/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAPHSH_H
#define _IMAPHSH_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimaphsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMapAsHshTable;

template <class Element, class Key, class ElementOps>
class IGMapAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMapAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsHshTableCursor
                            (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsHshTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMapAsHshTable :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsHshTable <Element, Key, ElementOps> Self;

  typedef  IMapAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapAsHshTableCursor
            <Element, Key, ElementOps> Cursor;


           IGMapAsHshTable
                            (INumber = 100);

           IGMapAsHshTable
                            (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsHshTable <Element, Key, ElementOps>&
           operator=        (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMapAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsHshTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMapAsHshTable :
  public IGMapAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IGMapAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef  IMapAsHshTable <Element, Key> Self;

#define IMapAsHshTableTypedef(Element, Key)\
  typedef  IMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMapAsHshTable
                            (INumber = 100);


protected:

           IMapAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMapAsHshTable :
  public IGMapAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGMapAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsHshTableTypedef (Element, Key, ElementOps);

public:

           IVGMapAsHshTable
                            (INumber = 100);


protected:

           IVGMapAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMapAsHshTable :
  public IVGMapAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IVGMapAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef  IVMapAsHshTable <Element, Key> Self;

#define IVMapAsHshTableTypedef(Element, Key)\
  typedef  IVMapAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMapAsHshTable
                            (INumber = 100);


protected:

           IVMapAsHshTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imaphsh.inl>

#pragma info (restore)
#pragma pack ()

#endif
