/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAPTAB_H
#define _IMAPTAB_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimaptab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMapAsTable;

template <class Element, class Key, class ElementOps>
class IGMapAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMapAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsTableCursor
                            (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMapAsTable :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsTable <Element, Key, ElementOps> Self;

  typedef  IMapAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGMapAsTable
                            (INumber = 100);

           IGMapAsTable
                            (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsTable <Element, Key, ElementOps>&
           operator=        (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMapAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMapAsTable :
  public IGMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IMapAsTable <Element, Key> Self;

#define IMapAsTableTypedef(Element, Key)\
  typedef  IMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMapAsTable
                            (INumber = 100);


protected:

           IMapAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMapAsTable :
  public IGMapAsTable
          <Element, Key, ElementOps > {

  typedef  IVGMapAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  IMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsTableTypedef (Element, Key, ElementOps);

public:

           IVGMapAsTable
                            (INumber = 100);


protected:

           IVGMapAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMapAsTable :
  public IVGMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVMapAsTable <Element, Key> Self;

#define IVMapAsTableTypedef(Element, Key)\
  typedef  IVMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMapAsTable
                            (INumber = 100);


protected:

           IVMapAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imaptab.inl>

#pragma info (restore)
#pragma pack ()

#endif
