/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsTableCursor <Element, Key, ElementOps>::
IGMapAsTableCursor
  (IGMapAsTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapAsTableCursor <Element, Key, ElementOps>&
IGMapAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGMapAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsTableCursor <Element, Key, ElementOps>::
IGMapAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMapAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsTable <Element, Key, ElementOps>::
IGMapAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMapAsTable <Element, Key, ElementOps>::
IGMapAsTable
  (IGMapAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsTable <Element, Key, ElementOps>&
IGMapAsTable <Element, Key, ElementOps>::
operator= (IGMapAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsTable <Element, Key, ElementOps>::
IGMapAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsTable
 <Element, Key, ElementOps>::Implementation&
IGMapAsTable <Element, Key, ElementOps>::
ImplOf (IGMapAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMapAsTable
// ---

// public members

template <class Element, class Key>
inline
IMapAsTable <Element, Key>::
IMapAsTable (INumber numberOfElements)
: IGMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMapAsTable <Element, Key>::
IMapAsTable (PureImplementation& impl)
: IGMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGMapAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsTable <Element, Key, ElementOps>::
IVGMapAsTable (INumber numberOfElements)
: IGMapAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsTable <Element, Key, ElementOps>::
IVGMapAsTable (PureImplementation& impl)
: IGMapAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMapAsTable
// ---

// public members

template <class Element, class Key>
inline
IVMapAsTable <Element, Key>::
IVMapAsTable (INumber numberOfElements)
: IVGMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMapAsTable <Element, Key>::
IVMapAsTable (PureImplementation& impl)
: IVGMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
