#ifndef _IMENU_
#define _IMENU_
/*******************************************************************************
* FILE NAME: imenu.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMenu                                                                    *
*     IMenu::Cursor                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>
#include <iframe.hpp>

class IMenuItem;
class IColor;
class IResourceId;
class IMenuData;
class IMenuCursorData;
struct _WidgetRec;

#pragma pack(4)

class IMenu : public IWindow {
typedef IWindow
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenu ( const IMenuHandle& menuHandle );

virtual
 ~IMenu ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IMenu, IWindow);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    aStyle );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------- Adding Items -------------------------------*/
virtual IMenu
 &addItem      ( IMenuItem&           menuItem,
                 unsigned long        intoSubmenuId = 0),
 &addText      ( unsigned long        newItemId,
                 const char*          itemText,
                 unsigned long        intoSubmenuId = 0),
 &addText      ( unsigned long        newItemId,
                 const IResourceId&   textResId,
                 unsigned long        intoSubmenuId = 0),
 &addBitmap    ( unsigned long        newItemId,
                 const IBitmapHandle& itemBitmap,
                 unsigned long        intoSubmenuId = 0),
 &addBitmap    ( unsigned long        newItemId,
                 const IResourceId&   bitmapResId,
                 unsigned long        intoSubmenuId = 0),
 &addBitmap    ( unsigned long        newItemId,
                 unsigned long        bitmapResId,
                 unsigned long        intoSubmenuId = 0),
 &addSeparator ( unsigned long        newItemId,
                 unsigned long        intoSubmenuId),
 &addSeparator ( unsigned long        intoSubmenuId = 0 ),
 &addSubmenu   ( unsigned long        itemId ),
 &addSubmenu   ( unsigned long        itemId,
                 const IResourceId&   submenuResId );

/*----------------------------- Replacing Items ------------------------------*/
virtual IMenu
 &setItem    ( const IMenuItem&     menuItem ),
 &setText    ( unsigned long        menuItemId,
               const char*          newText     ),
 &setText    ( unsigned long        menuItemId,
               const IResourceId&   newTextResId ),
 &setBitmap  ( unsigned long        menuItemId,
               const IBitmapHandle& bitmapHandle ),
 &setBitmap  ( unsigned long        menuItemId,
               const IResourceId&   newBitmapResId ),
 &setBitmap  ( unsigned long        menuItemId,
               unsigned long        newBitmapResId ),
 &setSubmenu ( unsigned long        itemId,
               const IResourceId&   submenuResId );

/*------------------------------ Removing Items ------------------------------*/
virtual IMenu
 &deleteItem    ( unsigned long itemId ),
 &removeSubmenu ( unsigned long itemWithSubmenuId );

/*-------------------------------- Selection ---------------------------------*/
virtual IMenu
 &checkItem     ( unsigned long itemId,
                  Boolean       check  = true ),
 &uncheckItem   ( unsigned long itemId ),
 &enableItem    ( unsigned long itemId,
                  Boolean       enable = true ),
 &disableItem   ( unsigned long itemId ),
 &selectItem    ( unsigned long itemId );

Boolean
  isItemChecked ( unsigned long itemId ) const,
  isItemEnabled ( unsigned long itemId ) const;

/*----------------------------- Item Properties ------------------------------*/
IMenuItem
  menuItem      ( unsigned long itemId ) const;
IRectangle
  itemRect      ( unsigned long itemId ) const;
unsigned long
  numberOfItems ( unsigned long forSubmenuId = 0 ) const;

/*----------------------------- Overrides ------------------------------------*/
virtual Boolean
  isValid            ( ) const,
  isFrameWindow      ( ) const;
virtual IWindow
 *owner              ( ) const;
virtual IMenu
 &enableUpdate       ( Boolean           enableWindow = true ),
 &disableUpdate      ( ),
 &refresh            ( RefreshType       type=paintAll ),
 &refresh            ( const IRectangle& invalidRectangle,
                       Boolean           immediate=false );
virtual unsigned long
  id                 ( ) const;

virtual IMenuHandle
  menuHandle    ( ) const;

virtual IMenu
 &setConditionalCascade    ( unsigned long itemWithSubmenuId,
                             unsigned long defaultItemId ),
 &removeConditionalCascade ( unsigned long itemWithSubmenuId );

/*----------------------------- Menu Item Help -------------------------------*/
virtual IMenu
 &setItemHelpId       ( unsigned long  menuItemId,
                        unsigned long  helpTopicId );
unsigned long
  itemHelpId          ( unsigned long  menuItemId ) const;

/*---------------------------------- Color -----------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  foregroundColor         ( ) const,
  backgroundColor         ( ) const;
#endif // !IC_WIN_FLAGNOP

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IColor
  disabledForegroundColor ( ) const,
  disabledBackgroundColor ( ) const,
  hiliteForegroundColor   ( ) const,
  hiliteBackgroundColor   ( ) const;
#endif // !IC_MOTIFWIN_FLAGNOP

#ifndef IC_WIN_FLAGNOP
virtual IMenu
  &setForegroundColor         ( const IColor& color ),
  &setBackgroundColor         ( const IColor& color );
#endif // !IC_WIN_FLAGNOP

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IMenu
  &setDisabledForegroundColor ( const IColor& color ),
  &setDisabledBackgroundColor ( const IColor& color ),
  &setHiliteForegroundColor   ( const IColor& color ),
  &setHiliteBackgroundColor   ( const IColor& color );

virtual IMenu
  &resetForegroundColor         ( ),
  &resetBackgroundColor         ( ),
  &resetDisabledForegroundColor ( ),
  &resetDisabledBackgroundColor ( ),
  &resetHiliteForegroundColor   ( ),
  &resetHiliteBackgroundColor   ( );
#endif // IC_MOTIFWIN_FLAGNOP

class Cursor : public IVBase {
public :
/*---------------------------- Constructors -----------------------------*/
  Cursor ( const IMenu& menu,
           unsigned long forSubmenuId = 0 );

virtual
 ~Cursor ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( );

/*-------------------------- Cursor Validation --------------------------*/
virtual Boolean
  isValid    ( ) const;
virtual void
  invalidate ( );

private:
/*--------------------------- Hidden Members ----------------------------*/
  Cursor ( const Cursor& cursor );

/*------------------------------- Private -------------------------------*/
friend class IMenu;

long
  lCurrent;
unsigned long
  ulSubmenu;
IMenu
 *pMenu;

IMenuCursorData
 *fCursorData;
}; // IMenu::Cursor

/*--------------------------- Cursored Operations ----------------------------*/
virtual IMenuItem
  elementAt       ( const Cursor& cursor ) const;

virtual IMenu
 &deleteAt        ( Cursor&       cursor ),
 &removeSubmenuAt ( Cursor&       cursor ),

 &add             ( IMenuItem&    menuItem,
                    Cursor&       cursor ),
 &addAsNext       ( IMenuItem&    menuItem,
                    Cursor&       cursor );

Cursor
  cursor          ( unsigned long itemId,
                    unsigned long inSubmenuId = 0 ) const;

/*-------------------------- Observer Notification ---------------------------*/
virtual IMenu
 &enableNotification ( Boolean enable = true );

protected:
/*------------------------------- Constructors -------------------------------*/
  IMenu ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMenu      ( const IMenu& menu );
IMenu
 &operator = ( const IMenu& menu );

/*--------------------------------- Private ----------------------------------*/
friend class IMenuBar;
friend class IPopUpMenu;
friend class ISubmenu;
friend class ISystemMenu;

unsigned long
  menuItemId     ( const Cursor&        cursor ) const;
void
  refCountBitmap ( const IBitmapHandle& handle );
IMenuHandle
  submenuHandle  ( unsigned long        submenuId ) const;
IMenuHandle
  fhMenu;
IWindowHandle
  fowner;
IFrameWindow
 *fmenuFrame;

static Style
  currentDefaultStyle;
void
 *pBitmapList;

IMenuData
 *fMenuData;

}; // IMenu

INESTEDBITFLAGCLASSFUNCS(Style, IMenu);

#pragma pack()

  #include <imenu.inl>

#endif  /* _IMENU_ */
