#ifndef _IMENUBAR_
#define _IMENUBAR_
/*******************************************************************************
* FILE NAME: imenubar.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMenuBar                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>

class IFrameWindow;
class IMenuBarData;
class IResourceId;

#pragma pack(4)

class IMenuBar : public IMenu {
typedef IMenu
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IMenuBar ( const IResourceId& menuResId,
             IFrameWindow*      owner);

  IMenuBar ( IFrameWindow*      owner,
             const Style&       style = defaultStyle() );

virtual
 ~IMenuBar ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IMenuBar, IWindow, IMenu);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU empty,
  IC_IMPORTU wrapper;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*----------------------------- Replacing Menus ------------------------------*/
virtual IMenuBar
  &setMenu        ( const IResourceId&  menuResId );


private:
/*------------------------------ Hidden Members ------------------------------*/
  IMenuBar   ( const IMenuBar& menuBar );
IMenuBar
 &operator = ( const IMenuBar& menuBar );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

IMenuBarData
 *fMenuBarData;

}; // IMenuBar

INESTEDBITFLAGCLASSFUNCS(Style, IMenuBar);

#pragma pack()

  #include <imenubar.inl>

#endif  /* _IMENUBAR_ */
