#ifndef _IMENUHDR_
#define _IMENUHDR_
/*******************************************************************************
* FILE NAME: imenuhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMenuHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <imenuevt.hpp>

class IMenuHandle;
class ISubmenu;

#pragma pack(4)

class IMenuHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuHandler ( );
virtual
 ~IMenuHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  makePopUpMenu ( IMenuEvent& menuEvent ),
  menuShowing   ( IMenuEvent& menuEvent,
                  ISubmenu&   submenuAboutToShow ),
  menuSelected  ( IMenuEvent& menuEvent ),
  menuEnded     ( IMenuEvent& menuEvent );

/*------------------------------ Menu Emphasis -------------------------------*/
virtual void
  addSourceEmphasis    ( const IMenuEvent& menuEvent ),
  removeSourceEmphasis ( const IMenuEvent& menuEvent );

private:
void
  cachePopupIdForEnd   ( const IMenuHandle& menuHandle,
                         unsigned long      itemId ),
  deletePopupCache     ();

void
 *fhMenuSelect,
 *fpPopCacheList;
}; // IMenuHandler

#pragma pack()

#endif /* IMENUHDR */
