#ifndef _IMETAIMP_
#define _IMETAIMP_
/*******************************************************************************
* FILE NAME: imetaimp.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Macros and template definitions for the classes:                           *
*     IMetaTypeInfo                                                            * 
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifdef IC_LIBRARYUSEONLY
//
// Added to reduce last minute changes...
//
typedef IMetaTypeInfo typeinfo;
#define typeid(x) dynamicTypeInfo(x)
#define static_type_info(x) staticTypeInfo(x)

#endif

#define staticTypeInfo(AType) (*AType::TGB((ITypeHelper*)0))

template <class AType>
inline const IMetaTypeInfo& dynamicTypeInfo(const AType& obj)
{
    const IMetaTypeInfo* info = 0;
#ifdef IC_LIBRARYUSEONLY
    info = obj.TGV();
#endif
    return *info;
}

inline int IMetaTypeInfo::operator==(const IMetaTypeInfo& other) const
{
    return (this == &other);
}

inline int IMetaTypeInfo::operator!=(const IMetaTypeInfo& other) const
{
    return (this != &other);
}

inline const char* IMetaTypeInfo::name() const
{
    return theName;
}

#ifdef IC_LIBRARYUSEONLY

#include <iostream.h>
#define TypeExtensionDeclarationsMacro(aname)\
    static const IMetaTypeInfo* gTypeInfo;\
    virtual const IMetaTypeInfo* TGV() const;\
    static const IMetaTypeInfo* TGB(ITypeHelper* helper);\
    static void*                TGD(const void* obj);\
    virtual void*               TGC(IBoolean returnThis) const;\
    static IString              TGCls();\
    static ITypeInstaller       gInstaller;
#define TypeExtensionMacro(aname)\
    const IMetaTypeInfo*        aname::gTypeInfo = 0;\
    const IMetaTypeInfo*        aname::TGV() const {\
        return TGB((ITypeHelper*)0); };\
    const IMetaTypeInfo*        aname::TGB(ITypeHelper* helper) {\
        if (helper == 0) {\
            if (gTypeInfo == 0)\                
                gTypeInfo = ITypeHelper::StaticCreate(TGCls(), &TGB, &TGD);\
            return gTypeInfo; }\
        else {\
            try { helper->ThrowObject(); } catch (aname* obj) { helper->CaughtObject(obj); }; return 0; } };\
    void*                       aname::TGD(const void* obj) {\
        if (obj == 0) {\
            return new aname(); }\
        else {\
            throw (aname*) obj; } };\
    void*                       aname::TGC(IBoolean returnThis) const {\
        if (returnThis) {\
            return (void*)this;\
        } else {\
            throw new aname(*this); } };\
    IString                     aname::TGCls() { return #aname; };\
    ITypeInstaller              aname::gInstaller(TGCls(), &TGB);
#define TypeExtensionDeclarationsMacro_Abstract(aname)\
    static const IMetaTypeInfo* gTypeInfo;\
    virtual const IMetaTypeInfo* TGV() const;\
    static const IMetaTypeInfo* TGB(ITypeHelper* helper);\
    static void*                TGD(const void* obj);\
    virtual void*               TGC(IBoolean returnThis) const;\
    static IString              TGCls();\
    static ITypeInstaller       gInstaller;
#define TypeExtensionMacro_Abstract(aname)\
    const IMetaTypeInfo*        aname::gTypeInfo = 0;\
    const IMetaTypeInfo*        aname::TGV() const {\
        return TGB((ITypeHelper*)0); };\
    const IMetaTypeInfo*        aname::TGB(ITypeHelper* helper) {\
        if (helper == 0) {\
            if (gTypeInfo == 0)\                
                gTypeInfo =     ITypeHelper::StaticCreate(TGCls(), &TGB, &TGD);\
            return gTypeInfo; }\
        else {\
            try { helper->ThrowObject(); } catch (aname* obj) { helper->CaughtObject(obj); }; return 0; } };\
    void*                       aname::TGD(const void* obj) {\
        if (obj == 0) {\
            return ITypeHelper::CantConstructAbstractClass(); }\
        else {\
            throw (aname*) obj; } };\
    void*                       aname::TGC(IBoolean returnThis) const {\
        if (returnThis) {\
            return (void*)this;\
        } else {\
            return (void*)ITypeHelper::CantConstructAbstractClass(); } };\
    IString                     aname::TGCls() { return #aname; };\
    ITypeInstaller              aname::gInstaller(TGCls(), &TGB);
#define TypeExtensionTemplateDeclarationsMacro(_tclass,_ptype)\
    static const IMetaTypeInfo* gTypeInfo;\
    virtual const IMetaTypeInfo* TGV() const;\
    static const IMetaTypeInfo* TGB(ITypeHelper* helper);\
    static void*                TGD(const void* obj);\
    virtual void*               TGC(IBoolean returnThis) const;\
    static IString              TGCls();\
    static ITypeInstaller       gInstaller;
#define TypeExtensionTemplateMacro(_tclass,_ptype)\
    template <class _ptype > const IMetaTypeInfo* _tclass<_ptype >::gTypeInfo = 0;\
    template <class _ptype > const IMetaTypeInfo* _tclass<_ptype >::TGV() const {\
        return TGB((ITypeHelper*)0); };\
    template <class _ptype > const IMetaTypeInfo* _tclass<_ptype >::TGB(ITypeHelper* helper) {\
        if (helper == 0) {\
            if (gTypeInfo == 0)\                
                gTypeInfo = ITypeHelper::StaticCreate(TGCls(), &TGB, &TGD);\
            return gTypeInfo; }\
        else {\
            try { helper->ThrowObject(); } catch (_tclass<_ptype >* obj) { helper->CaughtObject(obj); }; return 0; } };\
    template <class _ptype > void* _tclass<_ptype >::TGD(const void* obj) {\
        if (obj == 0) {\
            return new _tclass<_ptype >(); }\
        else {\
            throw (_tclass<_ptype >*) obj; } };\
    template <class _ptype > void* _tclass<_ptype >::TGC(IBoolean returnThis) const {\
        if (returnThis) {\
            return (void*)this;\
        } else {\
            throw new _tclass<_ptype >(*this); } };\
    template <class _ptype > IString _tclass<_ptype >::TGCls() { return ITypeHelper::MakeClassName(#_tclass, _ptype::TGCls(), 0); };\
    template <class _ptype > ITypeInstaller _tclass<_ptype >::gInstaller(TGCls(), &TGB);
#define TypeExtensionTemplateDeclarationsMacro_Abstract(_tclass,_ptype)\
    static const IMetaTypeInfo* gTypeInfo;\
    virtual const IMetaTypeInfo* TGV() const;\
    static const IMetaTypeInfo* TGB(ITypeHelper* helper);\
    static void*                TGD(const void* obj);\
    virtual void*               TGC(IBoolean returnThis) const;\
    static IString              TGCls();\
    static ITypeInstaller       gInstaller;
#define TypeExtensionTemplateMacro_Abstract(_tclass,_ptype)\
    template <class _ptype > const IMetaTypeInfo* _tclass<_ptype >::gTypeInfo = 0;\
    template <class _ptype > const IMetaTypeInfo* _tclass<_ptype >::TGV() const {\
        return TGB((ITypeHelper*)0); };\
    template <class _ptype > const IMetaTypeInfo* _tclass<_ptype >::TGB(ITypeHelper* helper) {\
        if (helper == 0) {\
            if (gTypeInfo == 0)\                
                gTypeInfo = ITypeHelper::StaticCreate(TGCls(), &TGB, &TGD);\
            return gTypeInfo; }\
        else {\
            try { helper->ThrowObject(); } catch (_tclass<_ptype >* obj) { helper->CaughtObject(obj); }; return 0; } };\
    template <class _ptype > void* _tclass<_ptype >::TGD(const void* obj) {\
        if (obj == 0) {\
            return ITypeHelper::CantConstructAbstractClass(); }\
        else {\
            throw (_tclass<_ptype >*) obj; } };\
    template <class _ptype > void* _tclass<_ptype >::TGC(IBoolean returnThis) const {\
        if (returnThis) {\
            return (void*)this;\
        } else {\
            return (void*)ITypeHelper::CantConstructAbstractClass(); } };\
    template <class _ptype > IString _tclass<_ptype >::TGCls() { return ITypeHelper::MakeClassName(#_tclass, _ptype::TGCls(), 0); };\
    template <class _ptype > ITypeInstaller _tclass<_ptype >::gInstaller(TGCls(), &TGB);
#define TypeExtensionTemplatePairDeclarationsMacro(_tclass,_ptypeK,_ptypeV)\
    static const IMetaTypeInfo* gTypeInfo;\
    virtual const IMetaTypeInfo* TGV() const;\
    static const IMetaTypeInfo* TGB(ITypeHelper* helper);\
    static void*                TGD(const void* obj);\
    virtual void*               TGC(IBoolean returnThis) const;\
    static IString              TGCls();\
    static ITypeInstaller       gInstaller;
#define TypeExtensionTemplatePairMacro(_tclass,_ptypeK,_ptypeV)\
    template <class _ptypeK, class _ptypeV > const IMetaTypeInfo* _tclass<_ptypeK,_ptypeV >::gTypeInfo = 0;\
    template <class _ptypeK, class _ptypeV > const IMetaTypeInfo* _tclass<_ptypeK,_ptypeV >::TGV() const {\
        return TGB((ITypeHelper*)0); };\
    template <class _ptypeK, class _ptypeV > const IMetaTypeInfo* _tclass<_ptypeK,_ptypeV >::TGB(ITypeHelper* helper) {\
        if (helper == 0) {\
            if (gTypeInfo == 0)\                
                gTypeInfo = ITypeHelper::StaticCreate(TGCls(), &TGB, &TGD);\
            return gTypeInfo; }\
        else {\
            try { helper->ThrowObject(); } catch (_tclass<_ptypeK,_ptypeV >* obj) { helper->CaughtObject(obj); }; return 0; } };\
    template <class _ptypeK, class _ptypeV > void* _tclass<_ptypeK,_ptypeV >::TGD(const void* obj) {\
        if (obj == 0) {\
            return new _tclass<_ptypeK,_ptypeV >(); }\
        else {\
            throw (_tclass<_ptypeK,_ptypeV >*) obj; } };\
    template <class _ptypeK, class _ptypeV > void* _tclass<_ptypeK,_ptypeV >::TGC(IBoolean returnThis) const {\
        if (returnThis) {\
            return (void*)this;\
        } else {\
            throw new _tclass<_ptypeK,_ptypeV >(*this); } };\
    template <class _ptypeK, class _ptypeV > IString _tclass<_ptypeK,_ptypeV >::TGCls() { return ITypeHelper::MakeClassName(#_tclass, _ptypeK::TGCls(), _ptypeV::TGCls()); };\
    template <class _ptypeK, class _ptypeV > ITypeInstaller _tclass<_ptypeK,_ptypeV >::gInstaller(TGCls(), &TGB);
#define TypeExtensionTemplatePairDeclarationsMacro_Abstract(_tclass,_ptypeK,_ptypeV)\
    static const IMetaTypeInfo* gTypeInfo;\
    virtual const IMetaTypeInfo* TGV() const;\
    static const IMetaTypeInfo* TGB(ITypeHelper* helper);\
    static void*                TGD(const void* obj);\
    virtual void*               TGC(IBoolean returnThis) const;\
    static IString              TGCls();\
    static ITypeInstaller       gInstaller;
#define TypeExtensionTemplatePairMacro_Abstract(_tclass,_ptypeK,_ptypeV)\
    template <class _ptypeK, class _ptypeV > const IMetaTypeInfo* _tclass<_ptypeK,_ptypeV >::gTypeInfo = 0;\
    template <class _ptypeK, class _ptypeV > const IMetaTypeInfo* _tclass<_ptypeK,_ptypeV >::TGV() const {\
        return TGB((ITypeHelper*)0); };\
    template <class _ptypeK, class _ptypeV > const IMetaTypeInfo* _tclass<_ptypeK,_ptypeV >::TGB(ITypeHelper* helper) {\
        if (helper == 0) {\
            if (gTypeInfo == 0)\                
                gTypeInfo = ITypeHelper::StaticCreate(TGCls(), &TGB, &TGD);\
            return gTypeInfo; }\
        else {\
            try { helper->ThrowObject(); } catch (_tclass<_ptypeK,_ptypeV >* obj) { helper->CaughtObject(obj); }; return 0; } };\
    template <class _ptypeK, class _ptypeV > void* _tclass<_ptypeK,_ptypeV >::TGD(const void* obj) {\
        if (obj == 0) {\
            return ITypeHelper::CantConstructAbstractClass(); }\
        else {\
            throw (_tclass<_ptypeK,_ptypeV >*) obj; } };\
    template <class _ptypeK, class _ptypeV > void* _tclass<_ptypeK,_ptypeV >::TGC(IBoolean returnThis) const {\
        if (returnThis) {\
            return (void*)this;\
        } else {\
            return (void*)ITypeHelper::CantConstructAbstractClass(); } };\
    template <class _ptypeK, class _ptypeV > IString _tclass<_ptypeK,_ptypeV >::TGCls() { return ITypeHelper::MakeClassName(#_tclass, _ptypeK::TGCls(), _ptypeV::TGCls()); };\
    template <class _ptypeK, class _ptypeV > ITypeInstaller _tclass<_ptypeK,_ptypeV >::gInstaller(TGCls(), &TGB);

class ITypeHelper {
public:
                            ITypeHelper(IBaseStream& aStream);
                            ITypeHelper();
                            ~ITypeHelper();

    // support for Flatten
    //
    IBoolean                MustStreamOutObject(const IMetaTypeInfo& baseTypeInfo, const IMetaTypeInfo* typeInfo, const void* obj);

    // support for Resurrect
    //
    const void*             ConstructObject(const IMetaTypeInfo& baseTypeInfo, IBoolean& mustStreamInObject);

    // support for DynamicCast
    //
    static const void*      DynamicCastImplementation(const IMetaTypeInfo& derivedTypeInfo, const IMetaTypeInfo& castToTypeInfo, const void* obj);

    // support for CreateNewObject
    //
    static const void*      ConstructObject(const IMetaTypeInfo& baseTypeInfo,
                                            const IMetaType& theType);

    void                    PrepareContext();
    unsigned long           UpdateContext(const void* newObj, IBoolean& update) const;
    const void*             LookupContext(unsigned long refNum) const;   
    void                    SetObject(const void* obj, const ITypeInternal* t);
    const void*             GetObject() const;

    void                    ThrowObject() const;
    void                    CaughtObject(const void* obj);

private:
    const void*             fObject;
    const ITypeInternal*    fObjectType;
    const ITypeInternal*    fBaseType;
    IBaseStream*            fStream;
    IBoolean                fCreatedContext;
    IBoolean                fMustStreamInObject;

public:
    enum EPreType           { kNil, kObject, kReference };
    static void*            CantConstructAbstractClass();
    static const IMetaTypeInfo* StaticCreate( const IString& className,
                                               const IMetaTypeInfo* (*tgbFunction)(ITypeHelper* helper),
                                               void* (*tgdFunction)(const void* obj));
    static IString          MakeClassName(const char* tName, const char* ptype1, const char* ptype2);
};

IBaseStream &operator <<=(ITypeHelper::EPreType& theValue, IBaseStream& fromwhere);
IBaseStream &operator >>=(ITypeHelper::EPreType theValue, IBaseStream& towhere);

#endif // IC_LIBRARYUSEONLY 


// ==================== T E M P L A T E   D E F I N I T I O N S ====================
//

template <class AType> AType* copy(const AType& source)
{
    AType* retVal = 0;
    try {
        // Use TGC to create a new instance of the original object
        // using the copy constructor
        source.TGC(false);
    } catch (AType* obj) {
        retVal = obj;
    }
    return retVal;
}

template <class AType> AType* copyPointer(const AType* sourcePtr)
{
    if (sourcePtr == 0)
        return 0;
    return ::copy(*sourcePtr);
}

template <class AType>
void flatten(const AType* userObjectToFlatten, IBaseStream& theStream)
{
#ifdef IC_LIBRARYUSEONLY
    ITypeHelper helper(theStream);
    const IMetaTypeInfo* dynamicType = 0;
    void* mostDerived = 0;
    if (userObjectToFlatten) {
        dynamicType = &dynamicTypeInfo(*userObjectToFlatten);
        mostDerived = userObjectToFlatten->TGC(true);
    }
    if (helper.MustStreamOutObject(staticTypeInfo(AType), dynamicType, mostDerived))
        *userObjectToFlatten >>= theStream;
#endif  // IC_LIBRARYUSEONLY 
}

template <class AType>
void resurrect(AType*& theResult, IBaseStream& theStream)
{
#ifdef IC_LIBRARYUSEONLY
    ITypeHelper helper(theStream);
    IBoolean mustStreamInObject;
    theResult = (AType*) helper.ConstructObject(staticTypeInfo(AType), mustStreamInObject);
    if (mustStreamInObject) *theResult <<= theStream;
#endif  // IC_LIBRARYUSEONLY 
}

template <class AType>
void createNewObject(AType*& theResult, const IMetaType& theType)
{
#ifdef IC_LIBRARYUSEONLY
    theResult = (AType*) ITypeHelper::ConstructObject(staticTypeInfo(AType), theType);
#endif  // IC_LIBRARYUSEONLY
}

template <class AType, class BType>
void
dynamicCastTo(AType*& target, BType* object)
{
#ifdef IC_LIBRARYUSEONLY
    if (object == 0) {
        target = 0;
    } else {
        target = (AType *) ITypeHelper::DynamicCastImplementation(dynamicTypeInfo(*object), staticTypeInfo(AType), object->TGC(true));
    }
#endif  // IC_LIBRARYUSEONLY
}


#endif // _IMETAIMP_
