#ifndef _IMETATYP_
#define _IMETATYP_
/*******************************************************************************
* FILE NAME: imetatyp.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMetaTypeInfo                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <istring.hpp>

class IBaseStream;
class IMetaType;

#ifdef IC_LIBRARYUSEONLY
class ITypeInternal;
#endif


#pragma pack(4)

class IMetaTypeInfo {
public:
const char
 *name            ( ) const;

int
  operator==      ( const IMetaTypeInfo& typeInfo ) const,
  operator!=      ( const IMetaTypeInfo& typeInfo ) const;

#ifdef IC_LIBRARYUSEONLY
public:
virtual
 ~IMetaTypeInfo   ( );

protected:
  IMetaTypeInfo   ( );
  IMetaTypeInfo   ( const IMetaTypeInfo& typeInfo );
IMetaTypeInfo
 &operator=       ( const IMetaTypeInfo& typeInfo );

private:
const char
 *theName;
ITypeInternal
 *fInternal;

friend class IMetaType;
friend class ITypeHelper;
friend class ITypeInternal;
  IMetaTypeInfo   ( const char* adoptedName );
ITypeInternal
 *GetTypeInternal ( ) const;
void
  SetTypeInternal ( ITypeInternal* typeInternal );
#endif
};

#ifndef IC_LIBRARYUSEONLY

#define staticTypeInfo(AType) (*((const IMetaTypeInfo*)0))
template <class AType> const IMetaTypeInfo& dynamicTypeInfo(const AType& obj);

#endif

class ITypeHelper;
class ITypeInstaller {
public:
  ITypeInstaller  ( const char* className,
                    const IMetaTypeInfo* (*tgbFunction)(ITypeHelper*) );
};

class IMetaType
{
public:
  IMetaType       ( const IMetaTypeInfo& typeInfo );
  IMetaType       ( const IMetaType&         type );
  IMetaType       ( );
virtual
 ~IMetaType       ( );

IMetaType
 &operator =      ( const IMetaType& type );
IBoolean
  operator ==     ( const IMetaType& type ) const;
IBoolean
  operator !=     ( const IMetaType& type ) const;
IBaseStream
 &operator >>=    ( IBaseStream& baseStream ) const,
 &operator <<=    ( IBaseStream& baseStream );

void
  name            ( IString& className ) const;    // why non-const
const IMetaTypeInfo
 &typeInfo        ( ) const;

#ifdef IC_LIBRARYUSEONLY

  IMetaType       ( const char* theClassName);

friend class ITypeHelper;

protected:

ITypeInternal
 *GetTypeInternal ( ) const;

private:
ITypeInternal
 *fInternalObject;

  // This stuff is an expansion of the type-information-on-the-side macros...
  // and is equivalent to saying, TypeExtensionDeclarationsMacro(IMetaType)
public:
  static const  IMetaTypeInfo*    gTypeInfo;
  virtual const IMetaTypeInfo*    TGV() const;
  static const  IMetaTypeInfo*    TGB(ITypeHelper* helper);
  static void*                    TGD(const void* other);
  virtual void*                   TGC(IBoolean returnThis) const;
  static IString                  TGCls();
  static ITypeInstaller           gInstaller;
#endif  // IC_LIBRARYUSEONLY

};

// ====================== M E T A D A T A   I N T E R F A C E ======================
//
// Here's the API template interface exported by this header...
//
template <class AType> AType* copy(const AType& sourceRef);
template <class AType> AType* copyPointer(const AType* sourcePtr);
template <class AType> void flatten(const AType* userObjectToFlatten, IBaseStream& theStream);
template <class AType> void resurrect(AType*& theResult, IBaseStream& theStream);
template <class AType> void createNewObject(AType*& theResult, const IMetaType& theType);
template <class AType, class BType> void dynamicCastTo(AType*& target, BType* object);

#ifndef IC_LIBRARYUSEONLY

// You must use one of the following macros to get special
// handling of your class by the Taligent type system...
//
#define TypeExtensionDeclarationsMacro(aname)
#define TypeExtensionMacro(aname)
#define TypeExtensionDeclarationsMacro_Abstract(aname)
#define TypeExtensionMacro_Abstract(aname)
#define TypeExtensionTemplateDeclarationsMacro(_tclass,_ptype)
#define TypeExtensionTemplateMacro(_tclass,_ptype)
#define TypeExtensionTemplateDeclarationsMacro_Abstract(_tclass,_ptype)
#define TypeExtensionTemplateMacro_Abstract(_tclass,_ptype)
#define TypeExtensionTemplatePairDeclarationsMacro(_tclass,_ptypeK,_ptypeV)
#define TypeExtensionTemplatePairMacro(_tclass,_ptypeK,_ptypeV)
#define TypeExtensionTemplatePairDeclarationsMacro_Abstract(_tclass,_ptypeK,_ptypeV)
#define TypeExtensionTemplatePairMacro_Abstract(_tclass,_ptypeK,_ptypeV)

#else

// This is the implementation internals for this header.
//
#include <imetaimp.hpp>

#endif // IC_LIBRARYUSEONLY


#pragma pack()


#pragma pack(4)


#endif
