#ifndef _IMMABUF_
   #define _IMMABUF_
/*******************************************************************************
* FILE NAME:  immabuf.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMAudioBuffer                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

class IMMAudioBufferData;
class IString;

#pragma pack(4)


class IMMAudioBuffer : public IBase {
typedef IBase
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMAudioBuffer  ( void* audioData,
                    unsigned long dataLength );
  IMMAudioBuffer  ( unsigned long dataLength = 0 );
  IMMAudioBuffer  ( const IMMAudioBuffer& audioBuffer );

IMMAudioBuffer
  &operator =     ( const IMMAudioBuffer& audioBuffer );

  ~IMMAudioBuffer ( );
/*-------------------------------- Format ------------------------------------*/
enum Format
{
  pcm      = 0x0001,
  adpcm,
  ibmcvsd  = 0x0005,
  alaw,
  mulaw,
  okiadpcm = 0x0010,
  dviadpcm,
  digistd  = 0x0015,
  digifix,
  ibmmulaw = 0x0101,
  ibmalaw,
  avcadpcm,
  ctadpcm  = 0x0200
};


private:
/*--------------------------------- Private ----------------------------------*/
IString
  *fBuffer;
void
  *fHeader;
unsigned long
  fLength;
IMMAudioBufferData
  *fAudioBufferData;

}; // IMMAudioBuffer


#pragma pack()

#endif /* _IMMABUF_ */
