#ifndef _IMMAUD_
   #define _IMMAUD_
/*******************************************************************************
* FILE NAME:  immaud.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMConfigurableAudio                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immrecrd.hpp>
#include <istring.hpp>
#include <immabuf.hpp>

class IMMDeviceSettings;

#pragma pack(4)


class IMMConfigurableAudio : public IMMRecordable {
typedef IMMRecordable
  Inherited;
public:
/*-------------------------- Constructor -------------------------------------*/
virtual
 ~IMMConfigurableAudio();

/*----------------------------- Audio Attributes -----------------------------*/
unsigned long
  bytesPerSecond       ( CallType call = wait ) const,
  bitsPerSample        ( CallType call = wait ) const,
  blockAlignment       ( CallType call = wait ) const,
  channels             ( CallType call = wait ) const,
  samplesPerSecond     ( CallType call = wait ) const;

IMMAudioBuffer::Format
  format               ( CallType call = wait) const;

virtual IMMConfigurableAudio
 &setBytesPerSecond    ( unsigned long averageBytes,
                         CallType call = wait ),
 &setBitsPerSample     ( unsigned long bitsPerSample,
                         CallType call = wait ),
 &setBlockAlignment    ( unsigned long alignment,
                         CallType call = wait ),
 &setChannels          ( unsigned long channels,
                         CallType call = wait ),
 &setFormat            ( IMMAudioBuffer::Format tag = IMMAudioBuffer::pcm,
                         CallType call = wait ),
 &setSamplesPerSecond  ( unsigned long samplesPerSecond,
                         CallType call = wait );

/*----------------------------- Audio Overrides -----------------------------*/
virtual IMMConfigurableAudio
 &setVolume   ( unsigned long volume,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait );
virtual unsigned long
  volume      ( AudioChannel channel = left,
                CallType call = wait ) const;

protected:
/*------------------------- Constructors -------------------------------------*/
  IMMConfigurableAudio ( const IString& deviceName,
                         Boolean openNow = true,
                         unsigned long instance = 0,
                         Boolean openShareable = true );
  IMMConfigurableAudio ( unsigned long deviceIdentifier,
                         const IString& newAlias = IString() );

/*----------------------------- Implementation -------------------------------*/
virtual unsigned long
  translateAudioFlag(unsigned long flag) const;

virtual IMMConfigurableAudio
 &saveDeviceSettings     ( ),
 &restoreDeviceSettings  ( Boolean newRecordMode = false );

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMConfigurableAudio  ( const IMMConfigurableAudio& device );
IMMConfigurableAudio
 &operator=             ( const IMMConfigurableAudio& device );

IMMDeviceSettings
 *fDeviceSettings;

}; // IMMConfiguableAudio


#pragma pack()

#endif /* _IMMAUD_ */
