#ifndef _IMMDVHDR_
   #define _IMMDVHDR_
/*******************************************************************************
* FILE NAME: immdvhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IMMDeviceHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>

class IMMDevice;
class IMMCuePointEvent;
class IMMDeviceEvent;
class IMMPassDeviceEvent;
class IMMPositionChangeEvent;
class IMMNotifyEvent;

#pragma pack(4)


class IMMDeviceHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMDeviceHandler();
virtual
  ~IMMDeviceHandler();

/*---------------------------- Device Attachment -----------------------------*/
virtual IMMDeviceHandler
 &handleEventsFor       ( IMMDevice* device ),
 &stopHandlingEventsFor ( IMMDevice* device );

/*-------------------------------- Event Processing --------------------------*/
virtual Boolean
#ifndef IC_WIN_FLAGNOP
  cuePoint        (const IMMCuePointEvent&   event),
  passDevice      (const IMMPassDeviceEvent& event),
#endif
  deviceEvent     (const IMMDeviceEvent&     event),
  positionChange  (const IMMPositionChangeEvent& event);

protected:
/*----------------------------- Notification ---------------------------------*/
virtual Boolean
  dispatchHandlerEvent    (IEvent& event);

private:
/*--------------------------------- Private ----------------------------------*/
virtual IMMDeviceHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );

}; // IMMDeviceHandler


#pragma pack()

#endif /* _IMMDVHDR_ */
