#ifndef _IMMEXCPT_
#define _IMMEXCPT_
/*******************************************************************************
* FILE NAME: immexcpt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMErrorInfo                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iexcept.hpp>

#pragma pack(4)


class IMMErrorInfo : public IBaseErrorInfo {
typedef IBaseErrorInfo
  Inherited;

public:
/*------------------------ Constructor ---------------------------------------*/
  IMMErrorInfo  ( unsigned long errorId = 0,
                  const char* functionName = 0 );
virtual
  ~IMMErrorInfo ( );

/*-------------------------------- Accessors ---------------------------------*/
virtual operator const char* () const;

virtual const char
 *text        ( ) const;
virtual unsigned long
  errorId     ( ) const;
virtual Boolean
  isAvailable ( ) const;

/*------------------------------ Throw Support -------------------------------*/
static void
  throwMMError  ( unsigned long             errorId,
                  const char*               functionName,
                  const IExceptionLocation& location,
                  IBaseErrorInfo::ExceptionType name = accessError,
                  IException::Severity      severity = recoverable );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
    ulClErrorId;
Boolean
    foundText;
char
 *pClFuncNameText;

/*--------------------------------- Hidden Functions -------------------------*/
  IMMErrorInfo ( const IMMErrorInfo& errorInformation );
IMMErrorInfo
  &operator=   ( const IMMErrorInfo& errorInformation );

}; // IMMErrorInfo


#define ITHROWMMERROR(errorId,func)\
    IMMErrorInfo::throwMMError(errorId, func, IEXCEPTION_LOCATION())

#define ITHROWMMERROR2(errorId, func, exType, sev)\
    IMMErrorInfo::throwMMError(errorId, func, IEXCEPTION_LOCATION(), exType, sev)


#pragma pack()

#endif /* _IMMEXCPT_ */
