#ifndef _IMMFILEM_
   #define _IMMFILEM_
/*******************************************************************************
* FILE NAME: immfilem.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMFileMedia                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immplayd.hpp>
#include <istring.hpp>

class IMMDeviceSettings;

#pragma pack(4)


class IMMFileMedia : public IMMPlayableDevice {
typedef IMMPlayableDevice
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
  ~IMMFileMedia();

/*------------------------------- File Loading -------------------------------*/
virtual IMMFileMedia
  &load         (const IString& filename,
                 Boolean readOnly = false,
                 CallType call = wait),
  &loadOnThread (const IString& filename,
                 Boolean readOnly = false);

IString
  filename      (CallType call = wait) const;

virtual Boolean
  isWriteable   () const;

/*-------------------------- Device open overrides ---------------------------*/
virtual IMMFileMedia
  &open              (const IString& fileOrDevice = IString(),
                      Boolean shareable = true,
                      CallType call = wait),
  &openOnThread      (const IString& fileOrDevice = IString(),
                      Boolean shareable = true,
                      CallType call = wait);

protected:
/*------------------------------- Constructors -------------------------------*/
  IMMFileMedia ( const IString& deviceName,
                 Boolean openNow,
                 unsigned long instance,
                 Boolean openShareable);

  IMMFileMedia ( unsigned long deviceIdentifier,
                 const IString& newAlias = IString());

/*---------------------------- Read Only Operations --------------------------*/
virtual IMMFileMedia
  &enableDataUpdate  ( Boolean update=true );

/*-------------------------- Device open overrides ---------------------------*/
virtual IMMFileMedia
  &open                   (unsigned long instanceNumber,
                           Boolean shareable = true,
                           CallType call = nowait),
  &openOnThread           (unsigned long instanceNumber,
                           Boolean shareable = true);

/*-------------------------------- Implementation ----------------------------*/
virtual IMMFileMedia
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (Boolean newRecordMode = false);

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMMFileMedia          ( const IMMFileMedia& device );
IMMFileMedia
 &operator=             ( const IMMFileMedia& device );

/*--------------------------------- Private ----------------------------------*/
Boolean
  fWriteable;

IMMDeviceSettings
  *fDeviceSettings ;

}; // IMMFileMedia


#pragma pack()

#endif /* _IMMFILEM_ */
