#ifndef _IMMPLAYD_
   #define _IMMPLAYD_
/*******************************************************************************
* FILE NAME: immplayd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMPlayableDevice                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immdev.hpp>

#include <itimer.hpp>

class IString;

class IMMDeviceSettings;

#pragma pack(4)


class IMMPlayableDevice : public IMMDevice {
typedef IMMDevice
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IMMPlayableDevice ();

/*----------------------------- Start and Stop -------------------------------*/
virtual IMMPlayableDevice
  &cueForPlayback       (CallType call = wait),
  &play                 (const IMMTime& from = IMMTime(),
                         const IMMTime& to   = IMMTime(),
                         Boolean resumeIfPaused = true,
                         CallType call = nowait),
  &stop                 (CallType call = wait);

/*----------------------------- Pause and Resume -----------------------------*/
virtual IMMPlayableDevice
  &pause                (CallType call = wait),
  &resume               (Boolean resume = true, CallType call = wait);

/*----------------------------- Seek -----------------------------------------*/
virtual IMMPlayableDevice
  &seek                 (const IMMTime& to, CallType call = wait),
  &seekToEnd            (CallType call = wait),
  &seekToStart          (CallType call = wait),
  &stepFrame            (unsigned long frames = 1, Boolean forward = true,
                         CallType call = wait);

/*----------------------------- Cue Points -----------------------------------*/

/*----------------------------- Notifications --------------------------------*/
virtual IMMPlayableDevice
  &stopPositionTracking (CallType call = wait),
  &startPositionTracking(const IMMTime& timeInterval, CallType call = wait);

unsigned long
  length                (CallType call = wait) const,
  position              (CallType call = wait) const;

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMPlayableDevice  (const IString& deviceOrFileName,
                      Boolean openNow = true,
                      unsigned long instance = 0,
                      Boolean openShareable = true);
  IMMPlayableDevice  (unsigned long deviceIdentifier,
                      const IString& newAlias = IString());

/*-------------------------------- Implementation ----------------------------*/
virtual IMMPlayableDevice
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (Boolean newRecordMode = false);

private:
/*--------------------------------- Private ----------------------------------*/

void
  setPositionAdvise (const IMMTime &time, Boolean on, CallType call);

// use this to emulate the OS/2 MCI_SET_POSITION_ADVISE command
ITimer
  positionTimer ;
void
  positionTimerChange() ;
IMMDeviceSettings
  *fDeviceSettings ;
}; // IMMPlayableDevice


#pragma pack()

#endif /* _IMMPLAYD_ */
