#ifndef _IMMPLYHD_
   #define _IMMPLYHD_
/*******************************************************************************
* FILE NAME:  immplyhd.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMPlayerPanelHandler                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icmdhdr.hpp>

class IMMPlayerPanel;

#pragma pack(4)


class IMMPlayerPanelHandler : public ICommandHandler {
typedef ICommandHandler
  Inherited;
public:
/*-------------------------- Constructors ------------------------------------*/
  IMMPlayerPanelHandler  ();
virtual
  ~IMMPlayerPanelHandler ();

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  command (ICommandEvent& event);

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  play               (const IMMPlayerPanel& panel),
  stop               (const IMMPlayerPanel& panel),
  pause              (const IMMPlayerPanel& panel),
  fastForward        (const IMMPlayerPanel& panel),
  rewind             (const IMMPlayerPanel& panel),
  stepForward        (const IMMPlayerPanel& panel),
  stepBackward       (const IMMPlayerPanel& panel);

}; // IMMPlayerPanelHandler


#pragma pack()

#endif /* _IMMPLYHD_ */
