#ifndef _IMMREMHD_
   #define _IMMREMHD_
/*******************************************************************************
* FILE NAME: immremhd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMRemovableMediaHandler                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immdvhdr.hpp>

class ITimer;
class IMMRemovableMedia;

#pragma pack(4)


class IMMRemovableMediaHandler : public IMMDeviceHandler {
typedef IMMDeviceHandler
  Inherited;
public:

/*----------------------------- Constructors ---------------------------------*/
  IMMRemovableMediaHandler();
virtual
  ~IMMRemovableMediaHandler();

/*-------------------------------- Media Loading -----------------------------*/
virtual IMMRemovableMediaHandler
  &mediaLoaded    (),
  &mediaUnloaded  ();

/*---------------------------- Device Attachment -----------------------------*/
virtual IMMRemovableMediaHandler
 &handleEventsFor ( IMMRemovableMedia* device ),
 &stopHandlingEventsFor ( IMMRemovableMedia* device );
/*-------------------------------- Event Processing --------------------------*/
virtual Boolean
  passDevice      (const IMMPassDeviceEvent& event);

protected:
/*-------------------------------- Event Dispatching -------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/

/*----------------------------- Hidden Functions -----------------------------*/
virtual IMMRemovableMediaHandler
 &handleEventsFor( IWindow* window ),
 &handleEventsFor ( IMMDevice* device ),
 &stopHandlingEventsFor ( IWindow* window ),
 &stopHandlingEventsFor ( IMMDevice* device );

}; // IMMRemovableMediaHandler


#pragma pack()

#endif /* _IMMREMHD_ */
