#ifndef _IMNDIEVT_
#define _IMNDIEVT_
/*******************************************************************************
* FILE NAME: imndievt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMenuDrawItemEvent                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idievt.hpp>

class IMenuDrawItemHandler;

#pragma pack(4)

class IMenuDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuDrawItemEvent ( IEvent& event );
virtual
 ~IMenuDrawItemEvent ( );

/*--------------------------- Menu Item Attributes ---------------------------*/
Boolean
  isSelected ( ) const,
  isChecked  ( ) const,
  isDisabled ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend IMenuDrawItemHandler;

Boolean
  isDrawItem        ( ) const,
  isSetHighlight    ( ) const,
  isRemoveHighlight ( ) const;
}; // IMenuDrawItemEvent

#pragma pack()

#endif /* _IMNDIEVT_ */
