#ifndef _IMNITEM_
#define _IMNITEM_
/*******************************************************************************
* FILE NAME: imnitem.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMenuItem                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ibitflag.hpp>
#include <ihandle.hpp>
#include <istring.hpp>

class IMenu;
class IResourceId;
class ISubmenu;
class IMenuItemData;

#pragma pack(4)

class IMenuItem : public IBase {
typedef IBase
  Inherited;

public:
class Style;
class Attribute;
/*------------------------------- Constructors -------------------------------*/
  IMenuItem ( unsigned long    itemId,
              const Style&     style     = defaultStyle(),
              const Attribute& attribute = defaultAttribute() );

  IMenuItem ( const IMenuItem& menuItem );

IMenuItem
 &operator= ( const IMenuItem& menuItem );

 ~IMenuItem ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IMenuItem);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU split,
  IC_IMPORTU splitWithSeparator,
  IC_IMPORTU drawItem,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU buttonSeparator,
#endif
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU postSystemCommand,
  IC_IMPORTU postHelp,
#endif
  IC_IMPORTU separator,
  IC_IMPORTU unavailable,
  IC_IMPORTU noStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

static const unsigned long
  IC_IMPORTU atEnd;

/*-------------------------------- Attributes --------------------------------*/
INESTEDBITFLAGCLASSDEF0(Attribute, IMenuItem);

static const Attribute
  IC_IMPORTU classDefaultAttribute,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU noDismiss,
  IC_IMPORTU framed,
#endif
  IC_IMPORTU highlighted,
  IC_IMPORTU checked,
  IC_IMPORTU disabled,
  IC_IMPORTU noAttribute;

static Attribute
  defaultAttribute    ( );

static void
  setDefaultAttribute ( const Attribute& attribute );

/*------------------------------- Menu Layout --------------------------------*/
enum LayoutType {
  normalLayout,
  splitLayout,
  splitWithSeparatorLayout
  };

IMenuItem
  &setLayout ( LayoutType    value );
LayoutType
  layoutType ( ) const;
IMenuItem
  &setIndex  ( unsigned long index = atEnd );
unsigned long
  index      ( ) const;

/*------------------------------ Command Type --------------------------------*/
enum CommandType {
  command,
  systemCommand,
  helpCommand
  };
IMenuItem
 &setCommand  ( CommandType value );
CommandType
  commandType ( ) const;

/*-------------------------------- Properties --------------------------------*/
unsigned long
  id              ( ) const;

IMenuItem
  &setSeparator   ( ),
  &setSelectable  ( Boolean     selectable  = true );
IMenuItem
  &setDrawItem    ( Boolean     drawItem    = true );

Boolean
  isSelectable    ( ) const,
  isDrawItem      ( ) const,
  isSeparator     ( ) const;

/*-------------------------------- Item State --------------------------------*/
IMenuItem
#ifndef IC_MOTIFWIN_FLAGNOP
  &setNoDismiss   ( Boolean noDismiss   = true ),
  &setFramed      ( Boolean framed      = true ),
#endif
  &setHighlighted ( Boolean highlighted = true ),
  &setChecked     ( Boolean checked     = true ),
  &setDisabled    ( Boolean disabled    = true );

Boolean
  isNoDismiss     ( ) const,
  isFramed        ( ) const,
  isHighlighted   ( ) const,
  isChecked       ( ) const,
  isDisabled      ( ) const;

/*---------------------------------- Label -----------------------------------*/
IMenuItem
  &setText   ( const char*          newText ),
  &setText   ( const IResourceId&   textResId ),
  &setBitmap ( const IBitmapHandle& menuItem ),
  &setBitmap ( const IResourceId&   bitmapResId ),
  &setBitmap ( unsigned long        bitmapResId );

IString
  text       ( ) const;

IBitmapHandle
  bitmap     ( ) const;

Boolean
  isText     ( ) const,
  isBitmap   ( ) const;

/*--------------------------------- Submenu ----------------------------------*/

IMenuItem
 &setSubmenuHandle ( const IMenuHandle& menuHandle );
IMenuHandle
  submenuHandle    ( ) const;

Boolean
  isSubmenu        ( ) const;

protected:

/*------------------------------ Implementation ------------------------------*/
IMenuItem
 &setExtendedStyle ( unsigned long newExtendedStyle ),
 &setStyle         ( unsigned long newStyle );

unsigned long
  extendedStyle    ( ) const,
  style            ( ) const;

IMenuItem
 &setAttribute     ( unsigned long newAttribute );
unsigned long
  attribute        ( ) const;

IMenuItem
 &setHelpId        ( unsigned long newHelpTopicId );
unsigned long
  helpId           ( ) const;

private:
/*-------------------------------- Private -----------------------------------*/
friend class IMenu;
static Style
  currentDefaultStyle;
static Attribute
  currentDefaultAttribute;
IString
  strClItemText;
unsigned long
  iPosition;
unsigned long
  afStyle,
  afExtendedStyle,
  afAttribute,
  itemId,
  afHelpId;
IMenuHandle
  hwndSubmenu;
IBitmapHandle
  hBitmapHandle;

static const Style
  IC_IMPORTU textItem,
  IC_IMPORTU bitmapItem,
  IC_IMPORTU submenu;

IMenuItemData
 *fMenuItemData;
}; // IMenuItem

#pragma pack()

  #include <imnitem.inl>

#endif  /* _IMNITEM_ */
