#ifndef _IMOUSEVT_
#define _IMOUSEVT_
/*******************************************************************************
* FILE NAME: imousevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMouseEvent                                                              *
*     IMouseClickEvent                                                         *
*     IMousePointerEvent                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IPoint;
class IWindowHandle;
class IPointerHandle;

#pragma pack(4)

class IMouseEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMouseEvent ( const IEvent& event );
virtual
 ~IMouseEvent ( );

/*--------------------------------- Position ---------------------------------*/
IPoint
  mousePosition ( ) const;

/*---------------------------- Window Information ----------------------------*/
IWindowHandle
  windowUnderPointer ( ) const;

/*------------------------------ Keyboard State ------------------------------*/
Boolean
  isAltKeyDown     ( ) const,
  isCtrlKeyDown    ( ) const,
  isShiftKeyDown   ( ) const;
}; // IMouseEvent

class IMouseClickEvent : public IMouseEvent {
typedef IMouseEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMouseClickEvent ( const IEvent& event );
virtual
 ~IMouseClickEvent ( );

/*------------------------------- Mouse Button -------------------------------*/
enum MouseButton {
  button1,
  button2,
  button3,
  buttonChord
  };

MouseButton
  mouseButton ( ) const;

/*------------------------------- Mouse Action -------------------------------*/
enum MouseAction {
  click,
  doubleClick,
  down,
  up
  };

MouseAction
  mouseAction ( ) const;

}; // IMouseClickEvent


class IMousePointerEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMousePointerEvent ( const IEvent& event );
virtual
 ~IMousePointerEvent ( );

/*------------------------------ Mouse Pointer -------------------------------*/
IPointerHandle
  defaultMousePointer ( ) const;

IMousePointerEvent
  &setMousePointer    ( const IPointerHandle& mousePointer );

/*---------------------------- Window Information ----------------------------*/
unsigned long
  windowId ( ) const;
}; // IMousePointerEvent

#pragma pack()

#endif /* _IMOUSEVT_ */
