/*******************************************************************************
* FILE NAME: imoushdr.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the template functions                *
*   declared in imoushdr.hpp.                                                  * 
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <imoushdr.hpp>

template<class ATarget>
IMouseConnectionTo<ATarget>::IMouseConnectionTo( ATarget&              target,
                                                 ClickMemberFunction   clickMemberFunction,
                                                 MoveMemberFunction    moveMemberFunction, 
                                                 PointerMemberFunction pointerMemberFunction )
: fTarget(target), 
  fConnectedClickMember(clickMemberFunction),
  fConnectedMoveMember(moveMemberFunction), 
  fConnectedPointerMember(pointerMemberFunction) 
{
}

template<class ATarget>
IMouseConnectionTo<ATarget>::~IMouseConnectionTo()
{
}

template<class ATarget>
Boolean
IMouseConnectionTo<ATarget>::mouseClicked( IMouseClickEvent& event )
{
    if ( fConnectedClickMember )
       return ( fTarget.*fConnectedClickMember ) ( event );
    else
       return false;
}
    
template<class ATarget>
Boolean
IMouseConnectionTo<ATarget>::mouseMoved( IMouseEvent& event )
{
    if ( fConnectedMoveMember )
       return ( fTarget.*fConnectedMoveMember ) ( event );
    else
       return false;
}
    
template<class ATarget>
Boolean
IMouseConnectionTo<ATarget>::mousePointerChange( IMousePointerEvent& event )
{   
    if ( fConnectedPointerMember )
       return ( fTarget.*fConnectedPointerMember ) ( event );
    else
       return false;
}

