#ifndef _IMOUSHDR_
#define _IMOUSHDR_
/*******************************************************************************
* FILE NAME: imoushdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMouseHandler                                                            *
*     IMouseConnectionTo                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <imousevt.hpp>

#pragma pack(4)

class IMouseHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMouseHandler ( );
virtual
 ~IMouseHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  mouseClicked       ( IMouseClickEvent&   event );

virtual Boolean
  mouseMoved         ( IMouseEvent&        event ),
  mousePointerChange ( IMousePointerEvent& event );

}; // IMouseHandler

#pragma info(nocpy)

template <class ATarget>
class IMouseConnectionTo : public IMouseHandler {
typedef IMouseHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef Boolean  (ATarget::* ClickMemberFunction)( IMouseClickEvent& );
typedef Boolean  (ATarget::* MoveMemberFunction)( IMouseEvent& );
typedef Boolean  (ATarget::* PointerMemberFunction)( IMousePointerEvent& );

/*------------------------------- Constructors -------------------------------*/
  IMouseConnectionTo ( ATarget&              target,
                       ClickMemberFunction   clickMemberFunction = 0,
                       MoveMemberFunction    moveMemberFunction = 0,
                       PointerMemberFunction pointerMemberFunction = 0 );
virtual
 ~IMouseConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  mouseClicked       ( IMouseClickEvent&   event ),
  mouseMoved         ( IMouseEvent&        event ),
  mousePointerChange ( IMousePointerEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
ClickMemberFunction
  fConnectedClickMember;
MoveMemberFunction
  fConnectedMoveMember;
PointerMemberFunction
  fConnectedPointerMember;
}; // IMouseConnectionTo


#ifndef __TEMPINC__
  #include <imoushdr.c>
#endif

#pragma info(restore)

#pragma pack()

#endif /* _IMOUSHDR_ */
